/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor.action;

import at.dallermassl.josm.plugin.surveyor.GpsActionEvent;
import at.dallermassl.josm.plugin.surveyor.SurveyorLock;
import at.dallermassl.josm.plugin.surveyor.SurveyorPlugin;
import at.dallermassl.josm.plugin.surveyor.action.AbstractSurveyorAction;
import at.dallermassl.josm.plugin.surveyor.action.gui.WaypointDialog;
import at.dallermassl.josm.plugin.surveyor.util.LayerUtil;
import java.util.List;
import javax.swing.JToggleButton;
import livegps.LiveGpsLayer;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class SetWaypointAction
extends AbstractSurveyorAction {
    private LiveGpsLayer liveGpsLayer;
    private MarkerLayer markerLayer;
    public static final String MARKER_LAYER_NAME = I18n.tr((String)"Surveyor waypoint layer", (Object[])new Object[0]);
    private WaypointDialog dialog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(GpsActionEvent event) {
        String markerTitle = this.getParameters().get(0);
        Object source = event.getSource();
        if (source instanceof JToggleButton) {
            markerTitle = ((JToggleButton)source).isSelected() ? I18n.tr((String)"{0} start", (Object[])new Object[]{markerTitle}) : I18n.tr((String)"{0} end", (Object[])new Object[]{markerTitle});
        }
        String iconName = this.getParameters().size() > 1 ? this.getParameters().get(1).trim() : null;
        long timeout = 5000L;
        if (this.getParameters().size() > 2) {
            try {
                timeout = Integer.parseInt(this.getParameters().get(2));
            }
            catch (NumberFormatException e) {
                Logging.error((String)e.getMessage());
            }
        }
        String markerText = markerTitle;
        if (timeout > 0L) {
            String inputText;
            if (this.dialog == null) {
                this.dialog = new WaypointDialog();
            }
            if ((inputText = this.dialog.openDialog(SurveyorPlugin.getSurveyorFrame(), I18n.tr((String)"Waypoint Description", (Object[])new Object[0]), timeout * 1000L)) != null && inputText.length() > 0) {
                inputText = inputText.replaceAll("<", "_");
                markerText = markerText + " " + inputText;
            }
        }
        MarkerLayer layer = this.getMarkerLayer();
        GpxLayer gpsLayer = this.getGpxLayer();
        WayPoint waypoint = new WayPoint(event.getCoordinates());
        waypoint.attr.put("name", markerText);
        if (iconName != null && !iconName.isEmpty()) {
            waypoint.attr.put("sym", iconName);
        }
        Class<SurveyorLock> clazz = SurveyorLock.class;
        synchronized (SurveyorLock.class) {
            layer.data.add(new Marker(event.getCoordinates(), markerText, iconName, null, -1.0, 0.0));
            if (gpsLayer != null) {
                gpsLayer.data.waypoints.add(waypoint);
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            MainApplication.getMap().repaint();
            return;
        }
    }

    public MarkerLayer getMarkerLayer() {
        if (this.markerLayer == null) {
            this.markerLayer = LayerUtil.findGpsLayer(MARKER_LAYER_NAME, MarkerLayer.class);
            if (this.markerLayer == null) {
                this.markerLayer = new MarkerLayer(new GpxData(), MARKER_LAYER_NAME, null, null);
                MainApplication.getLayerManager().addLayer((Layer)this.markerLayer);
            }
        }
        return this.markerLayer;
    }

    public GpxLayer getGpxLayer() {
        if (this.liveGpsLayer == null) {
            List layers = MainApplication.getLayerManager().getLayers();
            for (Layer layer : layers) {
                if (!(layer instanceof LiveGpsLayer)) continue;
                this.liveGpsLayer = (LiveGpsLayer)layer;
                break;
            }
        }
        return this.liveGpsLayer;
    }
}

