/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.component;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.component.Arguments;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.videosurface.CanvasVideoSurface;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class EmbeddedMediaPlayerComponent
extends Panel
implements MediaPlayerEventListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private final Logger logger = LoggerFactory.getLogger(EmbeddedMediaPlayerComponent.class);
    protected static final String[] DEFAULT_FACTORY_ARGUMENTS = new String[]{"--video-title=vlcj video output", "--no-snapshot-preview", "--quiet-synchro", "--sub-filter=logo:marq", "--intf=dummy"};
    private final MediaPlayerFactory mediaPlayerFactory = this.onGetMediaPlayerFactory();
    private final EmbeddedMediaPlayer mediaPlayer = this.mediaPlayerFactory.newEmbeddedMediaPlayer(this.onGetFullScreenStrategy());
    private final Canvas canvas = this.onGetCanvas();
    private final CanvasVideoSurface videoSurface = this.mediaPlayerFactory.newVideoSurface(this.canvas);
    private Cursor blankCursor;

    public EmbeddedMediaPlayerComponent() {
        this.mediaPlayer.setVideoSurface(this.videoSurface);
        this.setBackground(Color.black);
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.mediaPlayer.addMediaPlayerEventListener(this);
        switch (this.onGetInputEvents()) {
            case NONE: {
                break;
            }
            case DISABLE_NATIVE: {
                this.mediaPlayer.setEnableKeyInputHandling(false);
                this.mediaPlayer.setEnableMouseInputHandling(false);
            }
            case DEFAULT: {
                this.canvas.addMouseListener(this);
                this.canvas.addMouseMotionListener(this);
                this.canvas.addMouseWheelListener(this);
                this.canvas.addKeyListener(this);
            }
        }
        this.mediaPlayer.setOverlay(this.onGetOverlay());
        this.onAfterConstruct();
    }

    public final MediaPlayerFactory getMediaPlayerFactory() {
        return this.mediaPlayerFactory;
    }

    public final EmbeddedMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public final Canvas getVideoSurface() {
        return this.canvas;
    }

    public final void setCursorEnabled(boolean enabled) {
        this.setCursor(enabled ? null : this.getBlankCursor());
    }

    public final void release() {
        this.onBeforeRelease();
        this.mediaPlayer.release();
        this.onAfterRelease();
    }

    public final void release(boolean releaseFactory) {
        this.logger.debug("release(releaseFactory={})", (Object)releaseFactory);
        this.release();
        if (releaseFactory) {
            this.logger.debug("Releasing media player factory");
            this.mediaPlayerFactory.release();
        }
    }

    private Cursor getBlankCursor() {
        if (this.blankCursor == null) {
            BufferedImage blankImage = new BufferedImage(1, 1, 2);
            this.blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(blankImage, new Point(0, 0), "");
        }
        return this.blankCursor;
    }

    protected MediaPlayerFactory onGetMediaPlayerFactory() {
        Object[] args = Arguments.mergeArguments(this.onGetMediaPlayerFactoryArgs(), this.onGetMediaPlayerFactoryExtraArgs());
        this.logger.debug("args={}", (Object)Arrays.toString(args));
        return new MediaPlayerFactory((String[])args);
    }

    protected String[] onGetMediaPlayerFactoryArgs() {
        return DEFAULT_FACTORY_ARGUMENTS;
    }

    protected String[] onGetMediaPlayerFactoryExtraArgs() {
        return null;
    }

    protected FullScreenStrategy onGetFullScreenStrategy() {
        return null;
    }

    protected Canvas onGetCanvas() {
        Canvas canvas = new Canvas();
        canvas.setBackground(Color.black);
        return canvas;
    }

    protected InputEvents onGetInputEvents() {
        if (RuntimeUtil.isNix() || RuntimeUtil.isMac()) {
            return InputEvents.DEFAULT;
        }
        return InputEvents.DISABLE_NATIVE;
    }

    protected Window onGetOverlay() {
        return null;
    }

    protected void onAfterConstruct() {
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }

    @Override
    public void mediaChanged(MediaPlayer mediaPlayer, libvlc_media_t media, String mrl) {
    }

    @Override
    public void opening(MediaPlayer mediaPlayer) {
    }

    @Override
    public void buffering(MediaPlayer mediaPlayer, float newCache) {
    }

    @Override
    public void playing(MediaPlayer mediaPlayer) {
    }

    @Override
    public void paused(MediaPlayer mediaPlayer) {
    }

    @Override
    public void stopped(MediaPlayer mediaPlayer) {
    }

    @Override
    public void forward(MediaPlayer mediaPlayer) {
    }

    @Override
    public void backward(MediaPlayer mediaPlayer) {
    }

    @Override
    public void finished(MediaPlayer mediaPlayer) {
    }

    @Override
    public void timeChanged(MediaPlayer mediaPlayer, long newTime) {
    }

    @Override
    public void positionChanged(MediaPlayer mediaPlayer, float newPosition) {
    }

    @Override
    public void seekableChanged(MediaPlayer mediaPlayer, int newSeekable) {
    }

    @Override
    public void pausableChanged(MediaPlayer mediaPlayer, int newSeekable) {
    }

    @Override
    public void titleChanged(MediaPlayer mediaPlayer, int newTitle) {
    }

    @Override
    public void snapshotTaken(MediaPlayer mediaPlayer, String filename) {
    }

    @Override
    public void lengthChanged(MediaPlayer mediaPlayer, long newLength) {
    }

    @Override
    public void videoOutput(MediaPlayer mediaPlayer, int newCount) {
    }

    @Override
    public void scrambledChanged(MediaPlayer mediaPlayer, int newScrambled) {
    }

    @Override
    public void elementaryStreamAdded(MediaPlayer mediaPlayer, int type, int id) {
    }

    @Override
    public void elementaryStreamDeleted(MediaPlayer mediaPlayer, int type, int id) {
    }

    @Override
    public void elementaryStreamSelected(MediaPlayer mediaPlayer, int type, int id) {
    }

    @Override
    public void corked(MediaPlayer mediaPlayer, boolean corked) {
    }

    @Override
    public void muted(MediaPlayer mediaPlayer, boolean muted) {
    }

    @Override
    public void volumeChanged(MediaPlayer mediaPlayer, float volume) {
    }

    @Override
    public void audioDeviceChanged(MediaPlayer mediaPlayer, String audioDevice) {
    }

    @Override
    public void chapterChanged(MediaPlayer mediaPlayer, int newChapter) {
    }

    @Override
    public void error(MediaPlayer mediaPlayer) {
    }

    @Override
    public void mediaMetaChanged(MediaPlayer mediaPlayer, int metaType) {
    }

    @Override
    public void mediaSubItemAdded(MediaPlayer mediaPlayer, libvlc_media_t subItem) {
    }

    @Override
    public void mediaDurationChanged(MediaPlayer mediaPlayer, long newDuration) {
    }

    @Override
    public void mediaParsedChanged(MediaPlayer mediaPlayer, int newStatus) {
    }

    @Override
    public void mediaFreed(MediaPlayer mediaPlayer) {
    }

    @Override
    public void mediaStateChanged(MediaPlayer mediaPlayer, int newState) {
    }

    @Override
    public void mediaSubItemTreeAdded(MediaPlayer mediaPlayer, libvlc_media_t item) {
    }

    @Override
    public void newMedia(MediaPlayer mediaPlayer) {
    }

    @Override
    public void subItemPlayed(MediaPlayer mediaPlayer, int subItemIndex) {
    }

    @Override
    public void subItemFinished(MediaPlayer mediaPlayer, int subItemIndex) {
    }

    @Override
    public void endOfSubItems(MediaPlayer mediaPlayer) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public static enum InputEvents {
        NONE,
        DEFAULT,
        DISABLE_NATIVE;

    }
}

