/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.plugins.piclayer.transform.Matrix3D;
import org.openstreetmap.josm.plugins.piclayer.transform.NoSolutionException;

public class PictureTransform {
    private AffineTransform cachedTransform = new AffineTransform();
    private EastNorth imagePosition;
    private boolean modified = false;
    private List<Point2D> originPoints = new ArrayList<Point2D>(3);

    public EastNorth getImagePosition() {
        return this.imagePosition;
    }

    public void setImagePosition(EastNorth imagePosition) {
        this.imagePosition = imagePosition;
    }

    public AffineTransform getTransform() {
        return this.cachedTransform;
    }

    private AffineTransform solveEquation(List<Point2D> desiredPoints) throws NoSolutionException {
        Matrix3D X = new Matrix3D(this.originPoints);
        Matrix3D Y = new Matrix3D(desiredPoints);
        Matrix3D result = Y.multiply(X.inverse());
        return result.toAffineTransform();
    }

    public void addOriginPoint(Point2D originPoint) {
        if (this.originPoints.size() < 3) {
            this.originPoints.add(originPoint);
        }
    }

    public void resetCalibration() {
        this.originPoints.clear();
        this.modified = false;
        this.cachedTransform = new AffineTransform();
    }

    public void updatePair(Point2D originPoint, Point2D desiredPoint) {
        if (originPoint == null) {
            return;
        }
        switch (this.originPoints.size()) {
            case 1: {
                this.cachedTransform.concatenate(AffineTransform.getTranslateInstance(desiredPoint.getX() - originPoint.getX(), desiredPoint.getY() - originPoint.getY()));
                break;
            }
            case 2: {
                Point2D d1;
                Point2D d2;
                ArrayList<Point2D> desiredPoints = new ArrayList<Point2D>(3);
                Point2D o1 = this.originPoints.get(0);
                Point2D o2 = this.originPoints.get(1);
                if (o2 == originPoint) {
                    d2 = desiredPoint;
                    d1 = (Point2D)o1.clone();
                } else {
                    d1 = desiredPoint;
                    d2 = (Point2D)o2.clone();
                }
                Point2D o3 = this.calculateTrianglePoint(o1, o2);
                Point2D d3 = this.calculateTrianglePoint(d1, d2);
                this.originPoints.add(o3);
                desiredPoints.add(d1);
                desiredPoints.add(d2);
                desiredPoints.add(d3);
                this.trySolve(desiredPoints);
                this.originPoints.remove(2);
                break;
            }
            case 3: {
                ArrayList<Point2D> desiredPoints = new ArrayList<Point2D>(3);
                for (Point2D origin : this.originPoints) {
                    if (origin.equals(originPoint)) {
                        desiredPoints.add(desiredPoint);
                        continue;
                    }
                    desiredPoints.add(origin);
                }
                this.trySolve(desiredPoints);
                break;
            }
        }
    }

    private Point2D calculateTrianglePoint(Point2D d1, Point2D d2) {
        Point2D result = d1 instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        result.setLocation((d1.getX() + d2.getX() - d2.getY() + d1.getY()) / 2.0, (d1.getY() + d2.getY() + d2.getX() - d1.getX()) / 2.0);
        return result;
    }

    private void trySolve(List<Point2D> desiredPoints) {
        if (desiredPoints.size() == 3 && this.originPoints.size() == 3) {
            try {
                this.cachedTransform.concatenate(this.solveEquation(desiredPoints));
                this.modified = true;
                desiredPoints.clear();
            }
            catch (NoSolutionException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public void replaceOriginPoint(Point2D originPoint, Point2D newOriginPoint) {
        if (originPoint == null || newOriginPoint == null) {
            return;
        }
        int index = this.originPoints.indexOf(originPoint);
        if (index < 0) {
            return;
        }
        this.originPoints.set(index, newOriginPoint);
    }

    public void concatenateTransformPoint(AffineTransform transform, Point2D trans) {
        if (trans != null) {
            AffineTransform centered = AffineTransform.getTranslateInstance(trans.getX(), trans.getY());
            centered.concatenate(transform);
            centered.translate(-trans.getX(), -trans.getY());
            this.cachedTransform.concatenate(centered);
        } else {
            this.cachedTransform.concatenate(transform);
        }
        for (int i = 0; i < this.originPoints.size(); ++i) {
            Point2D point = this.originPoints.get(i);
            transform.transform(point, point);
        }
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public void resetModified() {
        this.modified = false;
    }

    public void setTransform(AffineTransform newTransform) {
        this.cachedTransform = new AffineTransform(newTransform);
    }

    public List<Point2D> getOriginPoints() {
        return this.originPoints;
    }

    public void setOriginPoints(List<Point2D> list) {
        this.originPoints = new ArrayList<Point2D>(list);
    }

    public void removeOriginPoint(Point2D selectedPoint) {
        this.originPoints.remove(selectedPoint);
    }
}

