/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class SignatureUtil {
    public static String createMethodSignature(String params, String returns) {
        String pString;
        if (params == null && returns == null) {
            return null;
        }
        if (params == null) {
            pString = ".*";
        } else {
            StringBuilder buf = new StringBuilder();
            StringTokenizer tok = new StringTokenizer(params, " \t\n\r\f,");
            while (tok.hasMoreTokens()) {
                String param = SignatureUtil.typeToSignature(tok.nextToken());
                buf.append(param);
            }
            pString = buf.toString();
        }
        String rString = returns == null ? ".*" : SignatureUtil.typeToSignature(returns);
        if (params == null || returns == null) {
            String result = "~\\(" + pString + "\\)" + rString;
            assert (Pattern.compile(result.substring(1)) != null);
            return result;
        }
        return "(" + pString + ")" + rString;
    }

    public static String createFieldSignature(String type) {
        if (type == null) {
            return null;
        }
        return SignatureUtil.typeToSignature(type);
    }

    private static String typeToSignature(String type) {
        if (type.endsWith("[]")) {
            return "[" + SignatureUtil.typeToSignature(type.substring(0, type.length() - 2));
        }
        return SignatureUtil.scalarTypeToSignature(type);
    }

    private static String scalarTypeToSignature(String type) {
        if ("boolean".equals(type)) {
            return "Z";
        }
        if ("byte".equals(type)) {
            return "B";
        }
        if ("char".equals(type)) {
            return "C";
        }
        if ("short".equals(type)) {
            return "S";
        }
        if ("int".equals(type)) {
            return "I";
        }
        if ("long".equals(type)) {
            return "J";
        }
        if ("float".equals(type)) {
            return "F";
        }
        if ("double".equals(type)) {
            return "D";
        }
        if ("void".equals(type)) {
            return "V";
        }
        return "L" + type.replace('.', '/') + ";";
    }
}

