/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;

public class SwitchHandler {
    private final List<SwitchDetails> switchOffsetStack = new ArrayList<SwitchDetails>();

    public int stackSize() {
        return this.switchOffsetStack.size();
    }

    int numEnumValues(@CheckForNull XClass c) {
        if (c == null) {
            return -1;
        }
        int total = 0;
        for (XField xField : c.getXFields()) {
            if (!xField.isEnum()) continue;
            ++total;
        }
        return total;
    }

    public void enterSwitch(DismantleBytecode dbc, @CheckForNull XClass enumType) {
        assert (dbc.getOpcode() == 170 || dbc.getOpcode() == 171);
        int[] switchOffsets = dbc.getSwitchOffsets();
        SwitchDetails details = new SwitchDetails(dbc.getPC(), switchOffsets, dbc.getDefaultSwitchOffset(), switchOffsets.length == this.numEnumValues(enumType));
        int size = this.switchOffsetStack.size();
        while (--size >= 0) {
            SwitchDetails existingDetail = this.switchOffsetStack.get(size);
            if (details.switchPC <= existingDetail.switchPC + existingDetail.swOffsets[existingDetail.swOffsets.length - 1]) continue;
            this.switchOffsetStack.remove(size);
        }
        this.switchOffsetStack.add(details);
    }

    public boolean isOnSwitchOffset(DismantleBytecode dbc) {
        int pc = dbc.getPC();
        if (pc == this.getDefaultOffset()) {
            return false;
        }
        return pc == this.getNextSwitchOffset(dbc);
    }

    public int getNextSwitchOffset(DismantleBytecode dbc) {
        for (int size = this.switchOffsetStack.size(); size > 0; --size) {
            SwitchDetails details = this.switchOffsetStack.get(size - 1);
            int nextSwitchOffset = details.getNextSwitchOffset(dbc.getPC());
            if (nextSwitchOffset >= 0) {
                return nextSwitchOffset;
            }
            if (dbc.getPC() <= details.getDefaultOffset()) {
                return -1;
            }
            this.switchOffsetStack.remove(size - 1);
        }
        return -1;
    }

    public int getDefaultOffset() {
        int size = this.switchOffsetStack.size();
        if (size == 0) {
            return -1;
        }
        SwitchDetails details = this.switchOffsetStack.get(size - 1);
        return details.getDefaultOffset();
    }

    public SourceLineAnnotation getCurrentSwitchStatement(BytecodeScanningDetector detector) {
        if (this.switchOffsetStack.isEmpty()) {
            throw new IllegalStateException("No current switch statement");
        }
        SwitchDetails details = this.switchOffsetStack.get(this.switchOffsetStack.size() - 1);
        return SourceLineAnnotation.fromVisitedInstructionRange(detector.getClassContext(), detector, details.switchPC, details.switchPC + details.maxOffset - 1);
    }

    public static class SwitchDetails {
        final int switchPC;
        final int[] swOffsets;
        final int defaultOffset;
        final int maxOffset;
        int nextOffset;
        final boolean exhaustive;

        public SwitchDetails(int pc, int[] offsets, int defOffset, boolean exhaustive) {
            this.switchPC = pc;
            int uniqueOffsets = 0;
            int lastValue = -1;
            int maxOffset = defOffset;
            for (int offset : offsets) {
                if (maxOffset < offset) {
                    maxOffset = offset;
                }
                if (offset == defOffset) {
                    exhaustive = false;
                }
                if (offset == lastValue) continue;
                ++uniqueOffsets;
                lastValue = offset;
            }
            this.maxOffset = maxOffset;
            this.swOffsets = new int[uniqueOffsets];
            int insertPos = 0;
            lastValue = -1;
            for (int offset1 : offsets) {
                if (offset1 == lastValue) continue;
                this.swOffsets[insertPos++] = offset1;
                lastValue = offset1;
            }
            this.defaultOffset = defOffset;
            this.nextOffset = 0;
            this.exhaustive = exhaustive;
        }

        public int getNextSwitchOffset(int currentPC) {
            while (this.nextOffset < this.swOffsets.length && currentPC > this.switchPC + this.swOffsets[this.nextOffset]) {
                ++this.nextOffset;
            }
            if (this.nextOffset >= this.swOffsets.length) {
                return -1;
            }
            return this.switchPC + this.swOffsets[this.nextOffset];
        }

        public int getDefaultOffset() {
            if (this.exhaustive) {
                return Short.MIN_VALUE;
            }
            return this.switchPC + this.defaultOffset;
        }
    }
}

