/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.util.JavaWebStart;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class TestDesktopIntegration
extends JPanel {
    private static String[] propertyNames = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"};
    JTextArea console = new JTextArea(24, 80);
    static URL url;
    PrintWriter writer = new PrintWriter(new ConsoleWriter());
    static final boolean SHOW_CONSOLE;
    static final boolean SHOW_FILE_CHOOSER;

    public static void main(String[] args) throws Exception {
        String u = SystemProperties.getProperty("findbugs.browserTestURL", "http://findbugs.sourceforge.net/");
        url = new URL(u);
        SwingUtilities.invokeLater(() -> TestDesktopIntegration.createAndShowGUI());
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("SpotBugs browser integration Test");
        frame.setDefaultCloseOperation(3);
        frame.add(new TestDesktopIntegration());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public TestDesktopIntegration() {
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout());
        this.add((Component)top, SHOW_CONSOLE ? "North" : "Center");
        if (SHOW_CONSOLE) {
            JScrollPane scrollPane = new JScrollPane(this.console, 22, 32);
            this.console.setEditable(false);
            this.console.setLineWrap(true);
            this.add(scrollPane);
        } else {
            this.add((Component)new JLabel("These buttons should view " + url), "North");
        }
        if (LaunchBrowser.desktopFeasible()) {
            JButton desktop = new JButton("Use java.awt.Desktop");
            desktop.addActionListener(e -> {
                try {
                    this.writer.println("Launch via desktop of " + url);
                    LaunchBrowser.viaDesktop(url.toURI());
                    this.writer.println("Launch via desktop completed");
                }
                catch (Throwable e1) {
                    this.writer.println("Launch via desktop failed");
                    e1.printStackTrace(this.writer);
                }
                this.writer.flush();
            });
            top.add(desktop);
        } else {
            this.writer.println("Desktop unavailable");
            LaunchBrowser.desktopException.printStackTrace(this.writer);
        }
        if (LaunchBrowser.webstartFeasible()) {
            JButton jnlp = new JButton("Use jnlp");
            jnlp.addActionListener(e -> {
                try {
                    this.writer.println("Launch via jnlp of " + url);
                    JavaWebStart.viaWebStart(url);
                    this.writer.println("Launch via jnlp completed");
                }
                catch (Throwable e1) {
                    this.writer.println("Launch via jnlp failed");
                    e1.printStackTrace(this.writer);
                }
                this.writer.flush();
            });
            top.add(jnlp);
        }
        JButton exec = new JButton("exec " + LaunchBrowser.execCommand);
        top.add(exec);
        if (LaunchBrowser.launchViaExec) {
            exec.addActionListener(e -> {
                try {
                    this.writer.println("Launch via exec " + LaunchBrowser.execCommand);
                    this.writer.println("url: " + url);
                    Process p = LaunchBrowser.launchViaExec(url);
                    Thread.sleep(3000L);
                    int exitValue = p.exitValue();
                    this.writer.println("Exit code: " + exitValue);
                    this.writer.println("Launch via exec completed");
                }
                catch (Throwable e1) {
                    this.writer.println("Launch via exec threw exception");
                    e1.printStackTrace(this.writer);
                }
                this.writer.flush();
            });
        } else {
            exec.disable();
        }
        if (SHOW_FILE_CHOOSER) {
            JButton chooseFile = new JButton("Choose file");
            top.add(chooseFile);
            chooseFile.addActionListener(e -> {
                JFileChooser fc = new JFileChooser();
                int retvel = fc.showOpenDialog(this);
                if (retvel == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        this.writer.println("File chosen:");
                        this.writer.println("File path: " + file.getAbsolutePath());
                        this.writer.println("File canonical path: " + file.getCanonicalPath());
                        this.writer.println("File uri: " + file.toURI());
                        this.writer.println("File url: " + file.toURL());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace(this.writer);
                    }
                    this.writer.flush();
                }
            });
        }
        if (SHOW_CONSOLE) {
            this.writer.println("System properties:");
            TreeSet<String> props = new TreeSet<String>();
            for (Object o : System.getProperties().keySet()) {
                if (!(o instanceof String)) continue;
                props.add((String)o);
            }
            props.addAll(Arrays.asList(propertyNames));
            for (String p : props) {
                try {
                    this.writer.println("  " + p + "=" + System.getProperty(p));
                }
                catch (Throwable e2) {
                    this.writer.println("Unable to get property " + p);
                }
            }
            try {
                Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
                Method getServiceNamesMethod = serviceManagerClass.getMethod("getServiceNames", new Class[0]);
                Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
                String[] serviceNames = (String[])getServiceNamesMethod.invoke(null, new Object[0]);
                this.writer.println("JNLP service providers:");
                for (String s : serviceNames) {
                    Object o = lookupMethod.invoke(null, s);
                    this.writer.println("  " + s + " = " + o.getClass().getName());
                }
            }
            catch (Exception e3) {
                this.writer.println("unable to get JNLP service provider:");
                e3.printStackTrace(this.writer);
            }
            String sampleURL = System.getProperty("findbugs.sampleURL");
            if (sampleURL != null) {
                try {
                    URL u = new URL(sampleURL);
                    this.writer.println("Checking access to " + u);
                    URLConnection c = u.openConnection();
                    this.writer.println("Content type: " + c.getContentType());
                    this.writer.println("Content length: " + c.getContentLength());
                }
                catch (Throwable e4) {
                    e4.printStackTrace(this.writer);
                }
            }
        }
    }

    static {
        SHOW_CONSOLE = SystemProperties.getBoolean("showConsole");
        SHOW_FILE_CHOOSER = SystemProperties.getBoolean("showFileChooser");
    }

    class ConsoleWriter
    extends Writer {
        ConsoleWriter() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            TestDesktopIntegration.this.console.append(new String(cbuf, off, len));
        }
    }
}

