/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowCFGPrinter;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Iterator;

public class TestDataflowAnalysis<Fact, AnalysisType extends DataflowAnalysis<Fact>>
implements Detector2,
NonReportingDetector {
    private final String dataflowClassName = SystemProperties.getProperty("dataflow.classname");
    private final String methodName = SystemProperties.getProperty("dataflow.method");
    private Class<? extends Dataflow<Fact, AnalysisType>> dataflowClass;
    private boolean initialized;

    public TestDataflowAnalysis(BugReporter bugReporter) {
    }

    @Override
    public void finishPass() {
    }

    @Override
    public String getDetectorClassName() {
        return this.getClass().getName();
    }

    @Override
    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        if (this.dataflowClassName == null) {
            return;
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (this.dataflowClass == null) {
            return;
        }
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        XClass classInfo = analysisCache.getClassAnalysis(XClass.class, classDescriptor);
        for (XMethod xMethod : classInfo.getXMethods()) {
            if (this.methodName != null && !this.methodName.equals(xMethod.getName())) continue;
            MethodDescriptor methodDescriptor = xMethod.getMethodDescriptor();
            System.out.println("-----------------------------------------------------------------");
            System.out.println("Method: " + SignatureConverter.convertMethodSignature(methodDescriptor));
            System.out.println("-----------------------------------------------------------------");
            Dataflow<Fact, AnalysisType> dataflow = analysisCache.getMethodAnalysis(this.dataflowClass, methodDescriptor);
            System.out.println("Dataflow finished after " + dataflow.getNumIterations());
            if (!SystemProperties.getBoolean("dataflow.printcfg")) continue;
            DataflowCFGPrinter<Fact, AnalysisType> cfgPrinter = new DataflowCFGPrinter<Fact, AnalysisType>(dataflow);
            cfgPrinter.print(System.out);
        }
    }

    private void initialize() {
        this.initialized = true;
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        Class<Dataflow<Fact, AnalysisType>> cls = null;
        try {
            Class<?> c = this.getClass().getClassLoader().loadClass(this.dataflowClassName);
            cls = this.asDataflowClass(c);
        }
        catch (ClassNotFoundException c) {
            // empty catch block
        }
        if (cls == null) {
            DetectorFactoryCollection detectorFactoryCollection = analysisCache.getDatabase(DetectorFactoryCollection.class);
            Iterator<Plugin> i = detectorFactoryCollection.pluginIterator();
            while (i.hasNext()) {
                Plugin plugin = i.next();
                try {
                    cls = this.asDataflowClass(plugin.getClassLoader().loadClass(this.dataflowClassName));
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        if (cls == null) {
            analysisCache.getErrorLogger().logError("TestDataflowAnalysis: could not load class " + this.dataflowClassName);
            return;
        }
        this.dataflowClass = cls;
    }

    private Class<? extends Dataflow<Fact, AnalysisType>> asDataflowClass(Class<?> c) {
        return c.asSubclass(Dataflow.class);
    }
}

