/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.HTMLBugReporter;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.BugLoader;
import edu.umd.cs.findbugs.gui2.BugSaver;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.FBFileChooser;
import edu.umd.cs.findbugs.gui2.FindBugsAnalysisFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBAFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBPFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFilterFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsHtmlFileFilter;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.PreferencesFrame;
import edu.umd.cs.findbugs.gui2.SaveType;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class MainFrameLoadSaveHelper
implements Serializable {
    private final MainFrame mainFrame;
    private FBFileChooser saveOpenFileChooser;
    private FBFileChooser filterOpenFileChooser;

    public MainFrameLoadSaveHelper(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void initialize() {
        this.saveOpenFileChooser = new FBFileChooser();
        this.saveOpenFileChooser.setFileSelectionMode(2);
        this.saveOpenFileChooser.setAcceptAllFileFilterUsed(false);
        this.saveOpenFileChooser.addChoosableFileFilter(FindBugsAnalysisFileFilter.INSTANCE);
        this.saveOpenFileChooser.addChoosableFileFilter(FindBugsFBPFileFilter.INSTANCE);
        this.saveOpenFileChooser.addChoosableFileFilter(FindBugsFBAFileFilter.INSTANCE);
        this.saveOpenFileChooser.setFileFilter(FindBugsAnalysisFileFilter.INSTANCE);
        this.saveOpenFileChooser.addChoosableFileFilter(FindBugsHtmlFileFilter.INSTANCE);
        this.filterOpenFileChooser = new FBFileChooser();
        this.filterOpenFileChooser.setFileSelectionMode(2);
        this.filterOpenFileChooser.setFileFilter(FindBugsFilterFileFilter.INSTANCE);
    }

    void importFilter() {
        this.filterOpenFileChooser.setDialogTitle(L10N.getLocalString("dlg.importFilter_ttl", "Import and merge filter..."));
        boolean retry = true;
        while (retry) {
            Filter filter;
            retry = false;
            int value = this.filterOpenFileChooser.showOpenDialog(this.mainFrame);
            if (value != 0) {
                return;
            }
            File f = this.filterOpenFileChooser.getSelectedFile();
            if (!f.exists()) {
                JOptionPane.showMessageDialog(this.filterOpenFileChooser, "No such file", "Invalid File", 2);
                retry = true;
                continue;
            }
            try {
                filter = Filter.parseFilter(f.getPath());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.filterOpenFileChooser, "Could not load filter.");
                retry = true;
                continue;
            }
            this.mainFrame.setProjectChanged(true);
            Filter suppressionFilter = this.mainFrame.getProject().getSuppressionFilter();
            for (Matcher m : filter.getChildren()) {
                suppressionFilter.addChild(m);
            }
            PreferencesFrame.getInstance().updateFilterPanel();
        }
    }

    void open() {
        if (this.askToSave()) {
            return;
        }
        boolean loading = true;
        block5: while (loading) {
            File f;
            int value = this.saveOpenFileChooser.showOpenDialog(this.mainFrame);
            if (value != 0) {
                return;
            }
            loading = false;
            SaveType fileType = this.convertFilterToType(this.saveOpenFileChooser.getFileFilter());
            if (!fileType.isValid(f = this.saveOpenFileChooser.getSelectedFile())) {
                JOptionPane.showMessageDialog(this.saveOpenFileChooser, "That file is not compatible with the chosen file type", "Invalid File", 2);
                loading = true;
                continue;
            }
            switch (fileType) {
                case XML_ANALYSIS: {
                    if (!f.getName().endsWith(".xml")) {
                        JOptionPane.showMessageDialog(this.saveOpenFileChooser, L10N.getLocalString("dlg.not_xml_data_lbl", "This is not a saved bug XML data file."));
                        loading = true;
                        continue block5;
                    }
                    if (this.mainFrame.openAnalysis(f, fileType)) continue block5;
                    JOptionPane.showMessageDialog(this.saveOpenFileChooser, "An error occurred while trying to load the analysis.");
                    loading = true;
                    continue block5;
                }
                case FBP_FILE: {
                    if (this.openFBPFile(f)) continue block5;
                    JOptionPane.showMessageDialog(this.saveOpenFileChooser, "An error occurred while trying to load the analysis.");
                    loading = true;
                    continue block5;
                }
                case FBA_FILE: {
                    if (this.openFBAFile(f)) continue block5;
                    JOptionPane.showMessageDialog(this.saveOpenFileChooser, "An error occurred while trying to load the analysis.");
                    loading = true;
                    continue block5;
                }
            }
            assert (false);
        }
    }

    private boolean askToSave() {
        if (this.mainFrame.isProjectChanged()) {
            int response = JOptionPane.showConfirmDialog(this.mainFrame, L10N.getLocalString("dlg.save_current_changes", "The current project has been changed, Save current changes?"), L10N.getLocalString("dlg.save_changes", "Save Changes?"), 1, 2);
            if (response == 0) {
                if (this.mainFrame.getSaveFile() != null) {
                    this.save();
                } else {
                    this.saveAs();
                }
            } else if (response == 2) {
                return true;
            }
        }
        return false;
    }

    boolean openFBAFile(File f) {
        return this.mainFrame.openAnalysis(f, SaveType.FBA_FILE);
    }

    boolean openFBPFile(File f) {
        if (!f.exists() || !f.canRead()) {
            return false;
        }
        this.prepareForFileLoad(f, SaveType.FBP_FILE);
        this.loadProjectFromFile(f);
        return true;
    }

    boolean exportFilter() {
        this.filterOpenFileChooser.setDialogTitle(L10N.getLocalString("dlg.exportFilter_ttl", "Export filter..."));
        boolean retry = true;
        while (retry) {
            retry = false;
            int value = this.filterOpenFileChooser.showSaveDialog(this.mainFrame);
            if (value != 0) {
                return false;
            }
            File f = this.filterOpenFileChooser.getSelectedFile();
            boolean alreadyExists = f.exists();
            if (alreadyExists) {
                int response = JOptionPane.showConfirmDialog(this.filterOpenFileChooser, L10N.getLocalString("dlg.file_exists_lbl", "This file already exists.\nReplace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                if (response == 0) {
                    retry = false;
                }
                if (response == 2) {
                    retry = true;
                    continue;
                }
            }
            Filter suppressionFilter = this.mainFrame.getProject().getSuppressionFilter();
            try {
                suppressionFilter.writeEnabledMatchersAsXML(new FileOutputStream(f));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.mainFrame, L10N.getLocalString("dlg.saving_error_lbl", "An error occurred in saving."));
                return false;
            }
        }
        return true;
    }

    boolean saveAs() {
        this.saveOpenFileChooser.setDialogTitle(L10N.getLocalString("dlg.saveas_ttl", "Save as..."));
        if (this.mainFrame.getCurrentProject() == null) {
            JOptionPane.showMessageDialog(this.mainFrame, L10N.getLocalString("dlg.no_proj_save_lbl", "There is no project to save"));
            return false;
        }
        boolean retry = true;
        SaveType fileType = SaveType.NOT_KNOWN;
        File f = null;
        while (retry) {
            retry = false;
            int value = this.saveOpenFileChooser.showSaveDialog(this.mainFrame);
            if (value != 0) {
                return false;
            }
            fileType = this.convertFilterToType(this.saveOpenFileChooser.getFileFilter());
            if (fileType == SaveType.NOT_KNOWN) {
                Debug.println("Error! fileType == SaveType.NOT_KNOWN");
                retry = true;
                continue;
            }
            f = this.saveOpenFileChooser.getSelectedFile();
            if (!fileType.isValid(f = this.convertFile(f, fileType))) {
                JOptionPane.showMessageDialog(this.saveOpenFileChooser, "That file is not compatible with the chosen file type", "Invalid File", 2);
                retry = true;
                continue;
            }
            boolean alreadyExists = this.fileAlreadyExists(f);
            if (alreadyExists) {
                int response = -1;
                switch (fileType) {
                    case HTML_OUTPUT: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("dlg.analysis_exists_lbl", "This html output already exists.\nReplace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                        break;
                    }
                    case XML_ANALYSIS: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("dlg.analysis_exists_lbl", "This analysis already exists.\nReplace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                        break;
                    }
                    case FBP_FILE: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("FB Project File already exists", "This FB project file already exists.\nDo you want to replace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                        break;
                    }
                    case FBA_FILE: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("FB Analysis File already exists", "This FB analysis file already exists.\nDo you want to replace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (response == 0) {
                    retry = false;
                }
                if (response == 2) {
                    retry = true;
                    continue;
                }
            }
            SaveReturn successful = SaveReturn.SAVE_ERROR;
            switch (fileType) {
                case HTML_OUTPUT: {
                    successful = this.printHtml(f);
                    break;
                }
                case XML_ANALYSIS: {
                    successful = this.saveAnalysis(f);
                    break;
                }
                case FBA_FILE: {
                    successful = this.saveFBAFile(f);
                    break;
                }
                case FBP_FILE: {
                    successful = this.saveFBPFile(f);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.mainFrame, "Unknown save file type");
                    return false;
                }
            }
            if (successful == SaveReturn.SAVE_SUCCESSFUL) continue;
            JOptionPane.showMessageDialog(this.mainFrame, L10N.getLocalString("dlg.saving_error_lbl", "An error occurred in saving."));
            return false;
        }
        assert (f != null);
        this.mainFrame.getSaveMenuItem().setEnabled(false);
        this.mainFrame.setSaveType(fileType);
        this.mainFrame.setSaveFile(f);
        File xmlFile = f;
        this.mainFrame.addFileToRecent(xmlFile);
        return true;
    }

    SaveType convertFilterToType(FileFilter f) {
        if (f instanceof FindBugsFileFilter) {
            return ((FindBugsFileFilter)f).getSaveType();
        }
        return SaveType.NOT_KNOWN;
    }

    boolean fileAlreadyExists(File f) {
        return f.exists();
    }

    File convertFile(File f, SaveType fileType) {
        if (!f.getName().endsWith(fileType.getFileExtension())) {
            f = new File(f.getAbsolutePath() + fileType.getFileExtension());
        }
        return f;
    }

    void save() {
        File sFile = this.mainFrame.getSaveFile();
        assert (sFile != null);
        SaveReturn result = SaveReturn.SAVE_ERROR;
        switch (this.mainFrame.getSaveType()) {
            case XML_ANALYSIS: {
                result = this.saveAnalysis(sFile);
                break;
            }
            case FBA_FILE: {
                result = this.saveFBAFile(sFile);
                break;
            }
            case FBP_FILE: {
                result = this.saveFBPFile(sFile);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.mainFrame, "Unknown save file type");
                return;
            }
        }
        if (result != SaveReturn.SAVE_SUCCESSFUL) {
            JOptionPane.showMessageDialog(this.mainFrame, L10N.getLocalString("dlg.saving_error_lbl", "An error occurred in saving."));
        }
    }

    SaveReturn saveFBAFile(File saveFile2) {
        return this.saveAnalysis(saveFile2);
    }

    SaveReturn saveFBPFile(File saveFile2) {
        try {
            this.mainFrame.getProject().writeXML(saveFile2, this.mainFrame.getBugCollection());
        }
        catch (IOException e) {
            AnalysisContext.logError("Couldn't save FBP file to " + saveFile2, e);
            return SaveReturn.SAVE_IO_EXCEPTION;
        }
        this.mainFrame.setProjectChanged(false);
        return SaveReturn.SAVE_SUCCESSFUL;
    }

    SaveReturn printHtml(File f) {
        Future<Object> waiter = this.mainFrame.getBackgroundExecutor().submit(() -> {
            HTMLBugReporter reporter = new HTMLBugReporter(this.mainFrame.getProject(), "default.xsl");
            reporter.setIsRelaxed(true);
            reporter.setOutputStream(UTF8.printStream(new FileOutputStream(f)));
            for (BugInstance bug : this.mainFrame.getBugCollection().getCollection()) {
                try {
                    if (!this.mainFrame.getViewFilter().show(bug)) continue;
                    reporter.reportBug(bug);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            reporter.finish();
            return null;
        });
        try {
            waiter.get();
        }
        catch (InterruptedException e) {
            return SaveReturn.SAVE_ERROR;
        }
        catch (ExecutionException e) {
            return SaveReturn.SAVE_ERROR;
        }
        return SaveReturn.SAVE_SUCCESSFUL;
    }

    SaveReturn saveAnalysis(File f) {
        Future<Object> waiter = this.mainFrame.getBackgroundExecutor().submit(() -> {
            BugSaver.saveBugs(f, this.mainFrame.getBugCollection(), this.mainFrame.getProject());
            return null;
        });
        try {
            waiter.get();
        }
        catch (InterruptedException e) {
            return SaveReturn.SAVE_ERROR;
        }
        catch (ExecutionException e) {
            return SaveReturn.SAVE_ERROR;
        }
        this.mainFrame.setProjectChanged(false);
        return SaveReturn.SAVE_SUCCESSFUL;
    }

    void prepareForFileLoad(File f, SaveType saveType) {
        this.closeProjectInternal();
        this.mainFrame.getReconfigMenuItem().setEnabled(true);
        this.mainFrame.setSaveType(saveType);
        this.mainFrame.setSaveFile(f);
        this.mainFrame.addFileToRecent(f);
    }

    void closeProject() {
        if (this.askToSave()) {
            return;
        }
        this.closeProjectInternal();
    }

    private void closeProjectInternal() {
        this.mainFrame.createProjectSettings();
        this.mainFrame.clearSourcePane();
        this.mainFrame.clearSummaryTab();
        this.mainFrame.setProjectChanged(false);
    }

    void loadAnalysis(File file) {
        Runnable runnable = () -> {
            this.mainFrame.acquireDisplayWait();
            try {
                Project project = new Project();
                project.setGuiCallback(this.mainFrame.getGuiCallback());
                project.setCurrentWorkingDirectory(file.getParentFile());
                BugLoader.loadBugs(this.mainFrame, project, file);
                project.getSourceFinder();
                this.mainFrame.updateBugTree();
            }
            finally {
                this.mainFrame.releaseDisplayWait();
            }
        };
        if (EventQueue.isDispatchThread()) {
            new Thread(runnable, "Analysis loading thread").start();
        } else {
            runnable.run();
        }
    }

    void loadAnalysis(URL url) {
        Runnable runnable = () -> {
            this.mainFrame.acquireDisplayWait();
            try {
                Project project = new Project();
                project.setGuiCallback(this.mainFrame.getGuiCallback());
                BugLoader.loadBugs(this.mainFrame, project, url);
                project.getSourceFinder();
                this.mainFrame.updateBugTree();
            }
            finally {
                this.mainFrame.releaseDisplayWait();
            }
        };
        if (EventQueue.isDispatchThread()) {
            new Thread(runnable, "Analysis loading thread").start();
        } else {
            runnable.run();
        }
    }

    void loadProjectFromFile(File f) {
        Runnable runnable = () -> {
            Project project = BugLoader.loadProject(this.mainFrame, f);
            BugCollection bc = project == null ? null : BugLoader.doAnalysis(project);
            this.mainFrame.updateProjectAndBugCollection(bc);
            this.mainFrame.setProjectAndBugCollectionInSwingThread(project, bc);
        };
        if (EventQueue.isDispatchThread()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    void mergeAnalysis() {
        this.mainFrame.acquireDisplayWait();
        try {
            BugCollection bc = BugLoader.combineBugHistories();
            this.mainFrame.setBugCollection(bc);
        }
        finally {
            this.mainFrame.releaseDisplayWait();
        }
    }

    static enum SaveReturn {
        SAVE_SUCCESSFUL,
        SAVE_IO_EXCEPTION,
        SAVE_ERROR;

    }
}

