/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.models;

import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.public_transport.TransText;
import org.openstreetmap.josm.plugins.public_transport.actions.StopImporterAction;
import org.openstreetmap.josm.plugins.public_transport.commands.WaypointsNameCommand;
import org.openstreetmap.josm.tools.I18n;

public class WaypointTableModel
extends DefaultTableModel
implements TableModelListener {
    private StopImporterAction controller = null;
    public boolean inEvent = false;
    public Vector<Node> nodes = new Vector();
    public Vector<LatLon> coors = new Vector();

    public WaypointTableModel(StopImporterAction controller) {
        this.controller = controller;
        this.addColumn(I18n.tr((String)"Time", (Object[])new Object[0]));
        this.addColumn(I18n.tr((String)"Stopname", (Object[])new Object[0]));
        this.addColumn(I18n.tr((String)"Shelter", (Object[])new Object[0]));
        this.addTableModelListener(this);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column >= 1;
    }

    @Override
    public void addRow(Object[] obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow(int insPos, Object[] obj) {
        throw new UnsupportedOperationException();
    }

    public void addRow(WayPoint wp) {
        this.insertRow(-1, wp);
    }

    public void insertRow(int insPos, WayPoint wp) {
        String name;
        String time = wp.getString("time");
        if (time == null) {
            time = "";
        }
        if ((name = wp.getString("name")) == null) {
            name = "";
        }
        Node node = this.controller.createNode(wp.getCoor(), name);
        Object[] buf = new Object[]{time, name, new TransText(null)};
        if (insPos == -1) {
            this.nodes.addElement(node);
            this.coors.addElement(wp.getCoor());
            super.addRow(buf);
        } else {
            this.nodes.insertElementAt(node, insPos);
            this.coors.insertElementAt(wp.getCoor(), insPos);
            super.insertRow(insPos, buf);
        }
    }

    public void clear() {
        this.nodes.clear();
        super.setRowCount(0);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            if (this.inEvent) {
                return;
            }
            Main.main.undoRedo.add((Command)new WaypointsNameCommand(this, e.getFirstRow(), (String)this.getValueAt(e.getFirstRow(), 1), (TransText)this.getValueAt(e.getFirstRow(), 2)));
        }
    }
}

