/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.commands;

import java.util.Collection;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.public_transport.actions.StopImporterAction;
import org.openstreetmap.josm.plugins.public_transport.models.TrackStoplistTableModel;
import org.openstreetmap.josm.tools.I18n;

public class TrackStoplistAddCommand
extends Command {
    private int workingLine;
    private TrackStoplistTableModel stoplistTM = null;

    public TrackStoplistAddCommand(StopImporterAction controller) {
        this.stoplistTM = controller.getCurrentTrack().stoplistTM;
        this.workingLine = controller.getDialog().getStoplistTable().getSelectedRow();
    }

    public boolean executeCommand() {
        this.stoplistTM.insertRow(this.workingLine, "00:00:00");
        return true;
    }

    public void undoCommand() {
        int workingLine = this.workingLine;
        if (workingLine < 0) {
            workingLine = this.stoplistTM.getRowCount() - 1;
        }
        this.stoplistTM.removeRow(workingLine);
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Add track stop", (Object[])new Object[0]);
    }
}

