/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.commands;

import java.util.Collection;
import java.util.Vector;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.public_transport.actions.StopImporterAction;
import org.openstreetmap.josm.plugins.public_transport.models.TrackStoplistTableModel;
import org.openstreetmap.josm.tools.I18n;

public class TrackStoplistDetachCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private Vector<Node> nodesForUndo = null;
    private TrackStoplistTableModel stoplistTM = null;

    public TrackStoplistDetachCommand(StopImporterAction controller) {
        int i;
        this.stoplistTM = controller.getCurrentTrack().stoplistTM;
        this.workingLines = new Vector();
        this.nodesForUndo = new Vector();
        int[] selectedLines = controller.getDialog().getStoplistTable().getSelectedRows();
        Vector<Integer> consideredLines = new Vector<Integer>();
        if (selectedLines.length > 0) {
            for (i = 0; i < selectedLines.length; ++i) {
                consideredLines.add(selectedLines[i]);
            }
        } else {
            for (i = 0; i < this.stoplistTM.getRowCount(); ++i) {
                consideredLines.add(i);
            }
        }
        for (i = 0; i < consideredLines.size(); ++i) {
            if (this.stoplistTM.nodeAt((Integer)consideredLines.elementAt(i)) == null) continue;
            this.workingLines.add((Integer)consideredLines.elementAt(i));
        }
    }

    public boolean executeCommand() {
        this.nodesForUndo.clear();
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.stoplistTM.nodeAt(j);
            this.nodesForUndo.add(node);
            this.stoplistTM.setNodeAt(j, null);
        }
        return true;
    }

    public void undoCommand() {
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.nodesForUndo.elementAt(i);
            this.stoplistTM.setNodeAt(j, node);
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Detach track stop list", (Object[])new Object[0]);
    }
}

