/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.public_transport.actions.GTFSImporterAction;
import org.openstreetmap.josm.plugins.public_transport.models.GTFSStopTableModel;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractGTFSCatchJoinCommand
extends Command {
    private List<Integer> workingLines = null;
    private Node undoMapNode = null;
    private Node undoTableNode = null;
    private GTFSStopTableModel gtfsStopTM = null;
    private String type = null;
    private final boolean isCatch;

    public AbstractGTFSCatchJoinCommand(GTFSImporterAction controller, boolean isCatch) {
        this.gtfsStopTM = controller.getGTFSStopTableModel();
        this.workingLines = new ArrayList<Integer>();
        this.isCatch = isCatch;
        int[] selectedLines = controller.getDialog().getGTFSStopTable().getSelectedRows();
        if (selectedLines.length != 1) {
            return;
        }
        this.workingLines.add(selectedLines[0]);
    }

    public boolean executeCommand() {
        Node node;
        if (this.workingLines.size() != 1) {
            return false;
        }
        Node dest = null;
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        Iterator iter = ds.getSelectedNodes().iterator();
        int j = this.workingLines.get(0);
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            if (n != null && n.equals((Object)this.gtfsStopTM.nodes.elementAt(j))) continue;
            if (dest != null) {
                return false;
            }
            dest = n;
        }
        if (dest == null) {
            return false;
        }
        this.undoMapNode = new Node(dest);
        this.undoTableNode = node = this.gtfsStopTM.nodes.elementAt(j);
        if (node != null) {
            ds.removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
        if (this.isCatch) {
            dest.setCoor(this.gtfsStopTM.coors.elementAt(j));
        }
        dest.put("highway", "bus_stop");
        dest.put("stop_id", (String)this.gtfsStopTM.getValueAt(j, 0));
        if (dest.get("name") == null) {
            dest.put("name", (String)this.gtfsStopTM.getValueAt(j, 1));
        }
        if (this.isCatch) {
            dest.put("note", "moved by gtfs import");
        }
        this.gtfsStopTM.nodes.set(j, dest);
        this.type = (String)this.gtfsStopTM.getValueAt(j, 2);
        this.gtfsStopTM.setValueAt(this.isCatch ? "fed" : I18n.tr((String)"moved", (Object[])new Object[0]), j, 2);
        return true;
    }

    public void undoCommand() {
        if (this.workingLines.size() != 1) {
            return;
        }
        int j = this.workingLines.get(0);
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        Node node = this.gtfsStopTM.nodes.elementAt(j);
        if (node != null) {
            ds.removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
        if (this.undoMapNode != null) {
            this.undoMapNode.setDeleted(false);
            ds.addPrimitive((OsmPrimitive)this.undoMapNode);
        }
        if (this.undoTableNode != null) {
            this.undoTableNode.setDeleted(false);
            ds.addPrimitive((OsmPrimitive)this.undoTableNode);
        }
        this.gtfsStopTM.nodes.set(j, this.undoTableNode);
        this.gtfsStopTM.setValueAt(this.type, j, 2);
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }
}

