/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import livegps.AppendableGpxTrackSegment;
import livegps.LiveGpsData;
import livegps.LiveGpsDrawHelper;
import livegps.SingleSegmentGpxTrack;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsLayer
extends GpxLayer
implements PropertyChangeListener {
    public static final String LAYER_NAME = I18n.tr((String)"LiveGPS layer", (Object[])new Object[0]);
    private static final int DEFAULT_REFRESH_INTERVAL = 250;
    private static final int DEFAULT_CENTER_INTERVAL = 5000;
    private static final int DEFAULT_CENTER_FACTOR = 80;
    private static final String oldC_REFRESH_INTERVAL = "livegps.refreshinterval";
    private static final String C_REFRESH_INTERVAL = "livegps.refresh_interval_msec";
    private static final String C_CENTER_INTERVAL = "livegps.center_interval_msec";
    private static final String C_CENTER_FACTOR = "livegps.center_factor";
    private int refreshInterval;
    private int centerInterval;
    private double centerFactor;
    private long lastRedraw = 0L;
    private long lastCenter = 0L;
    LiveGpsData lastData;
    LatLon lastPos;
    WayPoint lastPoint;
    private final AppendableGpxTrackSegment trackSegment;
    boolean autocenter;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public LiveGpsLayer(GpxData data) {
        super(data, LAYER_NAME);
        this.trackSegment = new AppendableGpxTrackSegment();
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("desc", "josm live gps");
        SingleSegmentGpxTrack trackBeingWritten = new SingleSegmentGpxTrack(this.trackSegment, attr);
        data.tracks.add(trackBeingWritten);
        this.initIntervals();
    }

    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent event) {
        return new LiveGpsDrawHelper(this);
    }

    void setCurrentPosition(double lat, double lon) {
        LatLon thisPos = new LatLon(lat, lon);
        if (this.lastPos != null && thisPos.equalsEpsilon(this.lastPos)) {
            return;
        }
        this.lastPos = thisPos;
        this.lastPoint = new WayPoint(thisPos);
        this.lastPoint.attr.put("time", this.dateFormat.format(new Date()));
        this.trackSegment.addWaypoint(this.lastPoint);
        if (this.autocenter) {
            this.conditionalCenter(thisPos);
        }
    }

    public void center() {
        if (this.lastPoint != null) {
            MainApplication.getMap().mapView.zoomTo(this.lastPoint.getCoor());
        }
    }

    public void conditionalCenter(LatLon Pos) {
        Point2D P = MainApplication.getMap().mapView.getPoint2D(Pos);
        Rectangle rv = MainApplication.getMap().mapView.getBounds(null);
        Date date = new Date();
        long current = date.getTime();
        rv.grow(-((int)(rv.getHeight() * this.centerFactor)), -((int)(rv.getWidth() * this.centerFactor)));
        if (!rv.contains(P) || this.centerInterval > 0 && current - this.lastCenter >= (long)this.centerInterval) {
            MainApplication.getMap().mapView.zoomTo(Pos);
            this.lastCenter = current;
        }
    }

    public void setAutoCenter(boolean ac) {
        this.autocenter = ac;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName())) {
            this.lastData = (LiveGpsData)evt.getNewValue();
            if (this.lastData.isFix()) {
                this.setCurrentPosition(this.lastData.getLatitude(), this.lastData.getLongitude());
                if (this.allowRedraw()) {
                    MainApplication.getMap().repaint();
                }
            }
        }
    }

    private boolean allowRedraw() {
        Date date = new Date();
        long current = date.getTime();
        if (current - this.lastRedraw >= (long)this.refreshInterval) {
            this.lastRedraw = current;
            return true;
        }
        return false;
    }

    private void initIntervals() {
        this.refreshInterval = Main.pref.getInt(oldC_REFRESH_INTERVAL, 0);
        if (this.refreshInterval != 0) {
            this.refreshInterval *= 1000;
            Main.pref.put(oldC_REFRESH_INTERVAL, null);
        } else {
            this.refreshInterval = Main.pref.getInt(C_REFRESH_INTERVAL, 250);
        }
        this.centerInterval = Main.pref.getInt(C_CENTER_INTERVAL, 5000);
        this.centerFactor = Main.pref.getInt(C_CENTER_FACTOR, 80);
        if (this.centerFactor <= 1.0 || this.centerFactor >= 99.0) {
            this.centerFactor = 80.0;
        }
        Main.pref.putInt(C_REFRESH_INTERVAL, this.refreshInterval);
        Main.pref.putInt(C_CENTER_INTERVAL, this.centerInterval);
        Main.pref.putInt(C_CENTER_FACTOR, (int)this.centerFactor);
        this.centerFactor = (100.0 - this.centerFactor) / 2.0 / 100.0;
    }
}

