/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Vector;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import public_transport.GTFSImporterAction;
import public_transport.GTFSStopTableModel;

public class GTFSDeleteCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private Vector<Node> nodesForUndo = null;
    private Vector<String> typesForUndo = null;
    private GTFSStopTableModel gtfsStopTM = null;

    public GTFSDeleteCommand(GTFSImporterAction controller) {
        int i;
        this.gtfsStopTM = controller.getGTFSStopTableModel();
        this.workingLines = new Vector();
        this.nodesForUndo = new Vector();
        this.typesForUndo = new Vector();
        int[] selectedLines = controller.getDialog().getGTFSStopTable().getSelectedRows();
        Vector<Integer> consideredLines = new Vector<Integer>();
        if (selectedLines.length > 0) {
            for (i = 0; i < selectedLines.length; ++i) {
                consideredLines.add(selectedLines[i]);
            }
        } else {
            for (i = 0; i < this.gtfsStopTM.getRowCount(); ++i) {
                consideredLines.add(i);
            }
        }
        for (i = 0; i < consideredLines.size(); ++i) {
            if (this.gtfsStopTM.nodes.elementAt((Integer)consideredLines.elementAt(i)) == null) continue;
            this.workingLines.add((Integer)consideredLines.elementAt(i));
        }
    }

    public boolean executeCommand() {
        this.nodesForUndo.clear();
        this.typesForUndo.clear();
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.gtfsStopTM.nodes.elementAt(j);
            this.nodesForUndo.add(node);
            this.typesForUndo.add((String)this.gtfsStopTM.getValueAt(j, 2));
            if (node == null) continue;
            this.gtfsStopTM.nodes.set(j, null);
            this.gtfsStopTM.setValueAt(I18n.tr((String)"skipped", (Object[])new Object[0]), j, 2);
            MainApplication.getLayerManager().getEditDataSet().removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
        return true;
    }

    public void undoCommand() {
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.nodesForUndo.elementAt(i);
            this.gtfsStopTM.nodes.set(j, node);
            this.gtfsStopTM.setValueAt(this.typesForUndo.elementAt(i), j, 2);
            if (node == null) continue;
            node.setDeleted(false);
            MainApplication.getLayerManager().getEditDataSet().addPrimitive((OsmPrimitive)node);
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Disable GTFS", (Object[])new Object[0]);
    }
}

