/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo;

import java.io.IOException;
import java.nio.file.Path;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoLotFile;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoRecord;
import org.openstreetmap.josm.tools.I18n;

public class EdigeoFileGEN
extends EdigeoLotFile<GenBlock> {
    public EdigeoFileGEN(EdigeoFileTHF.Lot lot, String seId, Path path) throws IOException {
        super(lot, seId, path);
        this.register("DEG", GeoBounds.class);
        this.register("GSE", GeoData.class);
        lot.gen = this;
    }

    public final GeoBounds getGeoBounds() {
        return this.blocks.getInstances(GeoBounds.class).get(0);
    }

    public static class GeoData
    extends GenBlock {
        String information = "";
        Structure structure;
        String offsetId = "";

        GeoData(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "INF": {
                    this.safeGetAndLog(r, s -> {
                        this.information = this.information + s;
                    }, I18n.tr((String)"Information", (Object[])new Object[0]));
                    break;
                }
                case "STR": {
                    this.structure = Structure.of(this.safeGetInt(r));
                    break;
                }
                case "REG": {
                    this.safeGet(r, (String s) -> {
                        this.offsetId = this.offsetId + s;
                    });
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && GeoData.areNotNull(new Object[]{this.structure});
        }

        public final String getInformation() {
            return this.information;
        }

        public final Structure getStructure() {
            return this.structure;
        }

        public final String getOffsetId() {
            return this.offsetId;
        }

        static enum Structure {
            TOPO_VECTOR(1),
            NETWORK(2),
            SPAGHETTI(3),
            REAL_MATRIX(4),
            CODED_MATRIX(5);

            final int code;

            private Structure(int code) {
                this.code = code;
            }

            public static Structure of(int code) {
                for (Structure s : Structure.values()) {
                    if (s.code != code) continue;
                    return s;
                }
                throw new IllegalArgumentException(Integer.toString(code));
            }
        }
    }

    public static class GeoBounds
    extends GenBlock {
        EastNorth min;
        EastNorth max;

        GeoBounds(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }

        @Override
        void processRecord(EdigeoRecord r) {
            switch (r.name) {
                case "CM1": {
                    this.min = this.safeGetEastNorth(r);
                    break;
                }
                case "CM2": {
                    this.max = this.safeGetEastNorth(r);
                    break;
                }
                default: {
                    super.processRecord(r);
                }
            }
        }

        @Override
        boolean isValid() {
            return super.isValid() && GeoBounds.areNotNull(this.min, this.max);
        }

        public final EastNorth getMinCm1() {
            return this.min;
        }

        public final EastNorth getMaxCm2() {
            return this.max;
        }

        public Bounds getBounds() {
            Projection proj = this.lot.geo.getCoorReference().getProjection();
            return new Bounds(proj.eastNorth2latlon(this.min), proj.eastNorth2latlon(this.max));
        }
    }

    static abstract class GenBlock
    extends EdigeoFileTHF.ChildBlock {
        GenBlock(EdigeoFileTHF.Lot lot, String type) {
            super(lot, type);
        }
    }
}

