/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo.pci;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileVEC;
import org.openstreetmap.josm.tools.Utils;

public class EdigeoPciReader
extends AbstractReader {
    private static final Map<String, List<String>> highways = new HashMap<String, List<String>>();

    private static void setName(OsmPrimitive p, String input) {
        if (input != null) {
            String name = input.replaceAll("    ", " ").replaceAll("   ", " ").replaceAll("  ", " ");
            if (name.length() > 2 && StringUtils.isAllUpperCase((CharSequence)name)) {
                name = WordUtils.capitalizeFully((String)name);
            }
            p.put("name", name);
        }
    }

    private static boolean setCorrectHighway(OsmPrimitive p, String[] words) {
        String type = words[0];
        for (Map.Entry<String, List<String>> e : highways.entrySet()) {
            if (!e.getValue().contains(type)) continue;
            p.put("highway", e.getKey());
            return true;
        }
        return false;
    }

    static DataSet parseDataSet(InputStream in, File file, ProgressMonitor instance) throws IOException {
        if (in != null) {
            in.close();
        }
        try {
            return new EdigeoPciReader().parse(file.toPath(), instance);
        }
        catch (IOException e) {
            throw e;
        }
        catch (AssertionError | Exception e) {
            throw new IOException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSet parse(Path path, ProgressMonitor instance) throws IOException, ReflectiveOperationException {
        Path tmpDir = null;
        Path thfPath = path;
        try {
            if (thfPath.toString().endsWith(".tar.bz2")) {
                try (InputStream fin = Files.newInputStream(path, new OpenOption[0]);
                     BufferedInputStream in = new BufferedInputStream(fin);
                     BZip2CompressorInputStream bzIn = new BZip2CompressorInputStream((InputStream)in);
                     TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)bzIn);){
                    TarArchiveEntry entry;
                    tmpDir = Files.createTempDirectory(Utils.getJosmTempDir().toPath(), "cadastre", new FileAttribute[0]);
                    while ((entry = tar.getNextTarEntry()) != null) {
                        File file = tmpDir.resolve(entry.getName()).toFile();
                        FileOutputStream out = new FileOutputStream(file);
                        Throwable throwable = null;
                        try {
                            if (IOUtils.copy((InputStream)tar, (OutputStream)out) < entry.getSize()) {
                                throw new IOException(String.format("Unable to write ''{0}'' entirely", file));
                            }
                            if (!file.toString().endsWith(".THF")) continue;
                            thfPath = file.toPath();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            out.close();
                        }
                    }
                }
            }
            DataSet data = new DataSet();
            data.setUploadPolicy(DataSet.UploadPolicy.DISCOURAGED);
            EdigeoFileTHF thf = new EdigeoFileTHF(thfPath).read().fill(data);
            data.setName(thf.getSupport().getBlockIdentifier());
            DataSet dataSet = data;
            return dataSet;
        }
        finally {
            if (tmpDir != null) {
                Utils.deleteDirectory((File)tmpDir.toFile());
            }
        }
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return null;
    }

    static {
        highways.put("motorway", Arrays.asList("Autoroute"));
        highways.put("trunk", Arrays.asList("Rocade"));
        highways.put("secondary", Arrays.asList("Avenue", "Boulevard", "Allee", "All\u00e9e", "Allees", "All\u00e9es", "Pont", "Port", "Route"));
        highways.put("residential", Arrays.asList("Chemin", "Impasse", "Place", "Rue", "Quai", "Voie", "Grand Rue"));
        EdigeoFileVEC.addIgnoredScdObjects("PTCANV_id", "BORNE_id", "BOULON_id", "CROIX_id", "SYMBLIM_id");
        EdigeoFileVEC.addIgnoredObject("SYM_id", "30", "31", "62", "64");
        EdigeoFileVEC.addObjectPostProcessor("12", "historic=wayside_cross");
        EdigeoFileVEC.addObjectPostProcessor("14", "amenity=place_of_worship;religion=christian");
        EdigeoFileVEC.addObjectPostProcessor("15", "amenity=place_of_worship;religion=muslim");
        EdigeoFileVEC.addObjectPostProcessor("16", "amenity=place_of_worship;religion=jewish");
        EdigeoFileVEC.addObjectPostProcessor("17", "boundary=administrative;admin_level=2");
        EdigeoFileVEC.addObjectPostProcessor("18", "boundary=administrative;admin_level=6");
        EdigeoFileVEC.addObjectPostProcessor("19", "boundary=administrative;admin_level=8");
        EdigeoFileVEC.addObjectPostProcessor("21", "highway=road");
        EdigeoFileVEC.addObjectPostProcessor("22", "highway=road");
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            String highwayValue = "path";
            if (p instanceof Way) {
                Way w = (Way)p;
                Predicate<Way> isBuilding = x -> x.hasKey("building");
                if (w.firstNode().getParentWays().stream().anyMatch(isBuilding) || w.lastNode().getParentWays().stream().anyMatch(isBuilding)) {
                    highwayValue = "footway";
                }
            }
            p.put("highway", highwayValue);
            p.remove("SYM_id");
        }, "SYM_id", "23");
        EdigeoFileVEC.addObjectPostProcessor("24", "man_made=pipeline");
        EdigeoFileVEC.addObjectPostProcessor("25", "man_made=pipeline");
        EdigeoFileVEC.addObjectPostProcessor("26", "aerialway=cable_car");
        EdigeoFileVEC.addObjectPostProcessor("27", "power=line");
        EdigeoFileVEC.addObjectPostProcessor("29", "railway=rail");
        EdigeoFileVEC.addObjectPostProcessor("33", "bridge=yes");
        EdigeoFileVEC.addObjectPostProcessor("34", "landuse=reservoir;natural=water;water=reservoir");
        EdigeoFileVEC.addObjectPostProcessor("37", "tunnel=yes");
        EdigeoFileVEC.addObjectPostProcessor("47", "railway=halt");
        EdigeoFileVEC.addObjectPostProcessor("48", "railway=stop");
        EdigeoFileVEC.addObjectPostProcessor("49", "railway=station");
        EdigeoFileVEC.addObjectPostProcessor("50", "man_made=mast");
        EdigeoFileVEC.addObjectPostProcessor("51", "landuse=cemetery;religion=christian");
        EdigeoFileVEC.addObjectPostProcessor("52", "landuse=cemetery;religion=muslim");
        EdigeoFileVEC.addObjectPostProcessor("53", "landuse=cemetery;religion=jewish");
        EdigeoFileVEC.addObjectPostProcessor("63", "man_made=water_well");
        EdigeoFileVEC.addObjectPostProcessor("65", "leisure=swimming_pool;access=private");
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            String t;
            String v;
            StringBuffer sb = new StringBuffer(p.get("TEX_id").trim());
            p.remove("TEX_id");
            Iterator<String> iterator = Arrays.asList("TEX2_id", "TEX3_id", "TEX4_id", "TEX5_id", "TEX6_id", "TEX7_id", "TEX8_id", "TEX9_id").iterator();
            while (iterator.hasNext() && (v = p.get(t = iterator.next())) != null) {
                sb.append(' ').append(v.trim());
                p.remove(t);
            }
            EdigeoPciReader.setName(p, sb.toString());
        }, "TEX_id", new String[0]);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            String[] words;
            p.put("highway", "road");
            String name = p.get("name");
            if (name != null && name.contains(" ") && !EdigeoPciReader.setCorrectHighway(p, words = name.split(" ")) && highways.values().stream().anyMatch(l -> l.contains(words[words.length - 1]))) {
                CharSequence[] newWords = new String[words.length];
                newWords[0] = words[words.length - 1];
                System.arraycopy(words, 0, newWords, 1, words.length - 1);
                p.put("name", String.join((CharSequence)" ", newWords));
                EdigeoPciReader.setCorrectHighway(p, (String[])newWords);
            }
        }, o -> o.hasScdIdentifier("ZONCOMMUNI_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("boundary", "administrative");
            p.put("admin_level", "8");
            p.put("ref:INSEE", "XX" + p.get("IDU_id"));
            p.put("name", WordUtils.capitalizeFully((String)p.get("TEX2_id")));
            p.remove("IDU_id");
            p.remove("TEX2_id");
        }, o -> o.hasScdIdentifier("COMMUNE_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("boundary", "cadastral");
            p.put("ref", p.get("IDU_id"));
            p.remove("IDU_id");
            p.remove("ICL_id");
            p.remove("COAR_id");
            p.remove("COPL_id");
            p.remove("DEDI_id");
            p.remove("DIS_id");
            p.remove("DRED_id");
            p.remove("EOR_id");
            p.remove("INDP_id");
            p.remove("INP_id");
            p.remove("QUPL_id");
            p.remove("SUPF_id");
        }, o -> o.hasScdIdentifier("SECTION_id") || o.hasScdIdentifier("SUBDSECT_id") || o.hasScdIdentifier("PARCELLE_id") || o.hasScdIdentifier("SUBDFISC_id") || o.hasScdIdentifier("CHARGE_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> p.put("wall", "no"), "DUR_id", "02");
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("building", "yes");
            p.remove("DUR_id");
        }, o -> o.hasScdIdentifier("BATIMENT_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("addr:housenumber", p.get("name"));
            p.remove("name");
        }, o -> o.hasScdIdentifier("NUMVOIE_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("place", "unknown");
            p.put("fixme", "place type");
        }, o -> o.hasScdIdentifier("LIEUDIT_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> p.remove("ORI_id"), o -> o.hasScdIdentifier("TPOINT_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("highway", "road");
            p.put("area", "yes");
        }, o -> o.hasScdIdentifier("TRONROUTE_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> p.put("waterway", "riverbank"), o -> o.hasScdIdentifier("TRONFLUV_id"));
        for (String t : Arrays.asList("TEX2_id", "TEX3_id", "TEX4_id", "TEX5_id", "TEX6_id", "TEX7_id", "TEX8_id", "TEX9_id")) {
            EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
                EdigeoPciReader.setName(p, p.get(t));
                p.remove(t);
            }, t, new String[0]);
        }
    }
}

