/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo.pci;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.io.importexport.OsmImporter;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.pci.EdigeoPciReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class EdigeoPciImporter
extends OsmImporter {
    static final ExtensionFileFilter EDIGEO_FILE_FILTER = new ExtensionFileFilter("thf,tar.bz2", "thf", I18n.tr((String)"Cadastre Edigeo files", (Object[])new Object[0]) + " (*.thf, *.tar.bz2)");
    protected File file;

    public EdigeoPciImporter() {
        super(EDIGEO_FILE_FILTER);
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        this.file = file;
        try (FileInputStream in = new FileInputStream(file);){
            this.importData(in, file, progressMonitor);
        }
        catch (FileNotFoundException e) {
            Logging.error((Throwable)e);
            throw new IOException(I18n.tr((String)"File ''{0}'' does not exist.", (Object[])new Object[]{file.getName()}), e);
        }
    }

    protected DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IllegalDataException {
        try {
            return EdigeoPciReader.parseDataSet(in, this.file, instance);
        }
        catch (IOException e) {
            throw new IllegalDataException((Throwable)e);
        }
    }
}

