/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo.pci;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileVEC;

public class EdigeoPciReader
extends AbstractReader {
    private static final Map<String, List<String>> highways = new HashMap<String, List<String>>();

    private static boolean setCorrectHighway(OsmPrimitive p, String[] words) {
        String type = words[0];
        for (Map.Entry<String, List<String>> e : highways.entrySet()) {
            if (!e.getValue().contains(type)) continue;
            p.put("highway", e.getKey());
            return true;
        }
        return false;
    }

    static DataSet parseDataSet(InputStream in, File file, ProgressMonitor instance) throws IOException {
        if (in != null) {
            in.close();
        }
        try {
            return new EdigeoPciReader().parse(file.toPath(), instance);
        }
        catch (IOException e) {
            throw e;
        }
        catch (AssertionError | Exception e) {
            throw new IOException((Throwable)e);
        }
    }

    DataSet parse(Path path, ProgressMonitor instance) throws IOException, ReflectiveOperationException {
        DataSet data = new DataSet();
        data.setUploadPolicy(DataSet.UploadPolicy.DISCOURAGED);
        EdigeoFileTHF thf = new EdigeoFileTHF(path).read().fill(data);
        data.setName(thf.getSupport().getBlockIdentifier());
        return data;
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return null;
    }

    static {
        highways.put("motorway", Arrays.asList("Autoroute"));
        highways.put("trunk", Arrays.asList("Rocade"));
        highways.put("secondary", Arrays.asList("Avenue", "Boulevard", "Allee", "All\u00e9e", "Allees", "All\u00e9es", "Pont", "Port", "Route"));
        highways.put("residential", Arrays.asList("Chemin", "Impasse", "Place", "Rue", "Quai", "Voie", "Grand Rue"));
        EdigeoFileVEC.addIgnoredObject("PTCANV_id", new String[0]);
        EdigeoFileVEC.addIgnoredObject("BORNE_id", new String[0]);
        EdigeoFileVEC.addIgnoredObject("BOULON_id", new String[0]);
        EdigeoFileVEC.addIgnoredObject("CROIX_id", new String[0]);
        EdigeoFileVEC.addIgnoredObject("SYMBLIM_id", new String[0]);
        EdigeoFileVEC.addIgnoredObject("SYM_id", "30", "31", "62", "64");
        EdigeoFileVEC.addObjectPostProcessor("12", "historic=wayside_cross");
        EdigeoFileVEC.addObjectPostProcessor("14", "amenity=place_of_worship;religion=christian");
        EdigeoFileVEC.addObjectPostProcessor("15", "amenity=place_of_worship;religion=muslim");
        EdigeoFileVEC.addObjectPostProcessor("16", "amenity=place_of_worship;religion=jewish");
        EdigeoFileVEC.addObjectPostProcessor("17", "boundary=administrative;admin_level=2");
        EdigeoFileVEC.addObjectPostProcessor("18", "boundary=administrative;admin_level=6");
        EdigeoFileVEC.addObjectPostProcessor("19", "boundary=administrative;admin_level=8");
        EdigeoFileVEC.addObjectPostProcessor("21", "highway=road");
        EdigeoFileVEC.addObjectPostProcessor("22", "highway=road");
        EdigeoFileVEC.addObjectPostProcessor("23", "highway=path");
        EdigeoFileVEC.addObjectPostProcessor("24", "man_made=pipeline");
        EdigeoFileVEC.addObjectPostProcessor("25", "man_made=pipeline");
        EdigeoFileVEC.addObjectPostProcessor("26", "aerialway=cable_car");
        EdigeoFileVEC.addObjectPostProcessor("27", "power=line");
        EdigeoFileVEC.addObjectPostProcessor("29", "railway=rail");
        EdigeoFileVEC.addObjectPostProcessor("33", "bridge=yes");
        EdigeoFileVEC.addObjectPostProcessor("34", "landuse=reservoir;natural=water;water=reservoir");
        EdigeoFileVEC.addObjectPostProcessor("37", "tunnel=yes");
        EdigeoFileVEC.addObjectPostProcessor("47", "railway=halt");
        EdigeoFileVEC.addObjectPostProcessor("48", "railway=stop");
        EdigeoFileVEC.addObjectPostProcessor("49", "railway=station");
        EdigeoFileVEC.addObjectPostProcessor("50", "man_made=mast");
        EdigeoFileVEC.addObjectPostProcessor("51", "landuse=cemetery;religion=christian");
        EdigeoFileVEC.addObjectPostProcessor("52", "landuse=cemetery;religion=muslim");
        EdigeoFileVEC.addObjectPostProcessor("53", "landuse=cemetery;religion=jewish");
        EdigeoFileVEC.addObjectPostProcessor("63", "man_made=water_well");
        EdigeoFileVEC.addObjectPostProcessor("65", "leisure=swimming_pool;access=private");
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            String t;
            String v;
            StringBuffer sb = new StringBuffer(p.get("TEX_id").trim());
            p.remove("TEX_id");
            Iterator<String> iterator = Arrays.asList("TEX2_id", "TEX3_id", "TEX4_id", "TEX5_id", "TEX6_id", "TEX7_id", "TEX8_id", "TEX9_id").iterator();
            while (iterator.hasNext() && (v = p.get(t = iterator.next())) != null) {
                sb.append(' ').append(v.trim());
                p.remove(t);
            }
            p.put("name", sb.toString().replaceAll("    ", " ").replaceAll("   ", " ").replaceAll("  ", " "));
        }, "TEX_id", new String[0]);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            String[] words;
            p.put("highway", "road");
            String name = p.get("name");
            if (name != null && name.contains(" ") && !EdigeoPciReader.setCorrectHighway(p, words = name.split(" ")) && highways.values().stream().anyMatch(l -> l.contains(words[words.length - 1]))) {
                CharSequence[] newWords = new String[words.length];
                newWords[0] = words[words.length - 1];
                System.arraycopy(words, 0, newWords, 1, words.length - 1);
                p.put("name", String.join((CharSequence)" ", newWords));
                EdigeoPciReader.setCorrectHighway(p, (String[])newWords);
            }
        }, o -> o.hasScdIdentifier("ZONCOMMUNI_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("boundary", "administrative");
            p.put("admin_level", "8");
            p.put("ref:INSEE", "XX" + p.get("IDU_id"));
            p.put("name", p.get("TEX2_id"));
            p.remove("IDU_id");
            p.remove("TEX2_id");
        }, o -> o.hasScdIdentifier("COMMUNE_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("boundary", "cadastral");
            p.put("ref", p.get("IDU_id"));
            p.remove("IDU_id");
        }, o -> o.hasScdIdentifier("SECTION_id") || o.hasScdIdentifier("SUBDSECT_id") || o.hasScdIdentifier("PARCELLE_id") || o.hasScdIdentifier("SUBDFISC_id") || o.hasScdIdentifier("CHARGE_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> p.put("wall", "no"), "DUR_id", "02");
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("building", "yes");
            p.remove("DUR_id");
        }, o -> o.hasScdIdentifier("BATIMENT_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("addr:housenumber", p.get("name"));
            p.remove("name");
        }, o -> o.hasScdIdentifier("NUMVOIE_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> p.put("place", "isolated_dwelling"), o -> o.hasScdIdentifier("LIEUDIT_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("highway", "road");
            p.put("area", "yes");
        }, o -> o.hasScdIdentifier("TRONROUTE_id"));
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> p.put("waterway", "riverbank"), o -> o.hasScdIdentifier("TRONFLUV_id"));
    }
}

