/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.tools;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Debouncer {
    private final ScheduledExecutorService scheduler;
    private final ConcurrentHashMap<Object, Future<?>> delayedMap = new ConcurrentHashMap();

    public Debouncer(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public void debounce(Object key, Runnable runnable, long delay, TimeUnit unit) {
        Future prev = this.delayedMap.put(key, this.scheduler.schedule(() -> {
            try {
                runnable.run();
            }
            finally {
                this.delayedMap.remove(key);
            }
        }, delay, unit));
        if (prev != null) {
            prev.cancel(true);
        }
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
    }
}

