/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.AbstractDownloadSourcePanel;
import org.openstreetmap.josm.gui.download.DownloadSettings;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.gui.download.DownloadSourceSizingPolicy;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.wikipedia.gui.WikosmQueryList;
import org.wikipedia.io.WikosmDownloadReader;

public class WikosmDownloadSource
implements DownloadSource<WikosmDownloadData> {
    public AbstractDownloadSourcePanel<WikosmDownloadData> createPanel() {
        return new WikosmDownloadSourcePanel(this);
    }

    public void doDownload(WikosmDownloadData data, DownloadSettings settings) {
        Bounds area = settings.getDownloadBounds().orElse(new Bounds(0.0, 0.0, 0.0, 0.0));
        DownloadOsmTask task = new DownloadOsmTask();
        task.setZoomAfterDownload(settings.zoomToData());
        Future future = task.download((OsmServerReader)new WikosmDownloadReader(area, WikosmDownloadReader.WIKOSM_SERVER.get(), data.getQuery(), settings.asNewLayer(), data.getDownloadReferrers(), data.getDownloadFull()), settings.asNewLayer(), area, null);
        MainApplication.worker.submit((Runnable)new PostDownloadHandler((DownloadTask)task, future, data.getErrorReporter()));
    }

    public String getLabel() {
        return I18n.tr((String)"Download from Wikosm API", (Object[])new Object[0]);
    }

    public boolean onlyExpert() {
        return true;
    }

    static class WikosmDownloadData {
        private final String query;
        private final boolean downloadReferrers;
        private final boolean downloadFull;
        private final Consumer<Collection<Object>> errorReporter;

        WikosmDownloadData(String query, boolean downloadReferrers, boolean downloadFull, Consumer<Collection<Object>> errorReporter) {
            this.query = query;
            this.downloadReferrers = downloadReferrers;
            this.downloadFull = downloadFull;
            this.errorReporter = errorReporter;
        }

        String getQuery() {
            return this.query;
        }

        boolean getDownloadReferrers() {
            return this.downloadReferrers;
        }

        boolean getDownloadFull() {
            return this.downloadFull;
        }

        Consumer<Collection<Object>> getErrorReporter() {
            return this.errorReporter;
        }
    }

    public static class WikosmDownloadSourcePanel
    extends AbstractDownloadSourcePanel<WikosmDownloadData> {
        private static final String SIMPLE_NAME = "wikosmdownloadpanel";
        private static final AbstractProperty<Integer> PANEL_SIZE_PROPERTY = new IntegerProperty("download.tabsplit.wikosmdownloadpanel", 150).cached();
        private static final BooleanProperty WIKOSM_QUERY_LIST_OPENED = new BooleanProperty("download.wikosm.query-list.opened", false);
        private static final String ACTION_IMG_SUBDIR = "dialogs";
        private final JosmTextArea wikosmQuery;
        private final WikosmQueryList wikosmQueryList;
        private final JCheckBox referrers;
        private final JCheckBox fullRel;

        public WikosmDownloadSourcePanel(WikosmDownloadSource ds) {
            super((DownloadSource)ds);
            this.setLayout(new BorderLayout());
            this.wikosmQuery = new JosmTextArea("# " + I18n.tr((String)"Enter your Wikosm SPARQL query below", (Object[])new Object[0]) + "\nSELECT ?osmId ?loc WHERE { BIND(osmnode:2681940767 as ?osmId). ?osmId osmm:loc ?loc . }", 8, 80);
            this.wikosmQuery.setFont(GuiHelper.getMonospacedFont((JComponent)this.wikosmQuery));
            this.wikosmQuery.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    wikosmQuery.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            this.wikosmQueryList = new WikosmQueryList((Component)((Object)this), (JTextComponent)this.wikosmQuery);
            this.wikosmQueryList.setPreferredSize(new Dimension(350, 300));
            EditSnippetAction edit = new EditSnippetAction();
            RemoveSnippetAction remove = new RemoveSnippetAction();
            this.wikosmQueryList.addSelectionListener(edit);
            this.wikosmQueryList.addSelectionListener(remove);
            JPanel listPanel = new JPanel(new GridBagLayout());
            listPanel.add((Component)new JLabel(I18n.tr((String)"Your saved queries:", (Object[])new Object[0])), GBC.eol().insets(2).anchor(10));
            listPanel.add((Component)((Object)this.wikosmQueryList), GBC.eol().fill(1));
            listPanel.add((Component)new JButton(new AddSnippetAction()), GBC.std().fill(2));
            listPanel.add((Component)new JButton(edit), GBC.std().fill(2));
            listPanel.add((Component)new JButton(remove), GBC.std().fill(2));
            listPanel.setVisible(WIKOSM_QUERY_LIST_OPENED.get());
            JScrollPane scrollPane = new JScrollPane((Component)this.wikosmQuery);
            BasicArrowButton arrowButton = new BasicArrowButton(listPanel.isVisible() ? 3 : 7);
            arrowButton.setToolTipText(I18n.tr((String)"Show/hide Wikosm snippet list", (Object[])new Object[0]));
            arrowButton.addActionListener(e -> {
                if (listPanel.isVisible()) {
                    listPanel.setVisible(false);
                    arrowButton.setDirection(7);
                    WIKOSM_QUERY_LIST_OPENED.put(Boolean.FALSE);
                } else {
                    listPanel.setVisible(true);
                    arrowButton.setDirection(3);
                    WIKOSM_QUERY_LIST_OPENED.put(Boolean.TRUE);
                }
            });
            this.referrers = new JCheckBox(I18n.tr((String)"Download referrers (parent relations)", (Object[])new Object[0]));
            this.referrers.setToolTipText(I18n.tr((String)"Select if the referrers of the object should be downloaded as well, i.e.,parent relations and for nodes, additionally, parent ways", (Object[])new Object[0]));
            this.referrers.setSelected(Config.getPref().getBoolean("wikosm.downloadprimitive.referrers", true));
            this.referrers.addActionListener(e -> Config.getPref().putBoolean("wikosm.downloadprimitive.referrers", this.referrers.isSelected()));
            this.fullRel = new JCheckBox(I18n.tr((String)"Download relation members", (Object[])new Object[0]));
            this.fullRel.setToolTipText(I18n.tr((String)"Select if the members of a relation should be downloaded as well", (Object[])new Object[0]));
            this.fullRel.setSelected(Config.getPref().getBoolean("wikosm.downloadprimitive.full", true));
            this.fullRel.addActionListener(e -> Config.getPref().putBoolean("wikosm.downloadprimitive.full", this.fullRel.isSelected()));
            JPanel centerPanel = new JPanel(new GridBagLayout());
            centerPanel.add((Component)scrollPane, GBC.eol().fill(1));
            centerPanel.add((Component)this.referrers, GBC.std().anchor(17).insets(5, 5, 5, 5));
            centerPanel.add((Component)this.fullRel, GBC.std().anchor(17).insets(15, 5, 5, 5));
            JPanel innerPanel = new JPanel(new BorderLayout());
            innerPanel.add((Component)centerPanel, "Center");
            innerPanel.add((Component)arrowButton, "East");
            this.add(innerPanel, "Center");
            this.add(listPanel, "East");
            this.setMinimumSize(new Dimension(450, 240));
        }

        public WikosmDownloadData getData() {
            String query = this.wikosmQuery.getText();
            Consumer<Collection<Object>> errorReporter = errors -> {
                boolean onlyNoDataError;
                boolean bl = onlyNoDataError = errors.size() == 1 && errors.contains("No data found in this area.");
                if (errors.isEmpty() || onlyNoDataError) {
                    this.wikosmQueryList.saveHistoricItem(query);
                }
            };
            return new WikosmDownloadData(query, this.referrers.isSelected(), this.fullRel.isSelected(), errorReporter);
        }

        public void rememberSettings() {
        }

        public void restoreSettings() {
        }

        public boolean checkDownload(DownloadSettings settings) {
            String query = this.getData().getQuery();
            if (!settings.getDownloadBounds().isPresent() && query.contains("{{bbox}}")) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr((String)"Please select a download area first.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                return false;
            }
            return true;
        }

        public Icon getIcon() {
            return ImageProvider.get((String)ACTION_IMG_SUBDIR, (String)"wikosm");
        }

        public String getSimpleName() {
            return SIMPLE_NAME;
        }

        public DownloadSourceSizingPolicy getSizingPolicy() {
            return new DownloadSourceSizingPolicy.AdjustableDownloadSizePolicy(PANEL_SIZE_PROPERTY);
        }

        private class EditSnippetAction
        extends AbstractAction
        implements ListSelectionListener {
            EditSnippetAction() {
                this.putValue("SmallIcon", ImageProvider.get((String)WikosmDownloadSourcePanel.ACTION_IMG_SUBDIR, (String)"edit"));
                this.putValue("ShortDescription", I18n.tr((String)"Edit selected snippet", (Object[])new Object[0]));
                this.checkEnabled();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                WikosmDownloadSourcePanel.this.wikosmQueryList.editSelectedItem();
            }

            void checkEnabled() {
                this.setEnabled(WikosmDownloadSourcePanel.this.wikosmQueryList.getSelectedItem().isPresent());
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.checkEnabled();
            }
        }

        private class RemoveSnippetAction
        extends AbstractAction
        implements ListSelectionListener {
            RemoveSnippetAction() {
                this.putValue("SmallIcon", ImageProvider.get((String)WikosmDownloadSourcePanel.ACTION_IMG_SUBDIR, (String)"delete"));
                this.putValue("ShortDescription", I18n.tr((String)"Delete selected snippet", (Object[])new Object[0]));
                this.checkEnabled();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                WikosmDownloadSourcePanel.this.wikosmQueryList.removeSelectedItem();
            }

            void checkEnabled() {
                this.setEnabled(WikosmDownloadSourcePanel.this.wikosmQueryList.getSelectedItem().isPresent());
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.checkEnabled();
            }
        }

        private class AddSnippetAction
        extends AbstractAction {
            AddSnippetAction() {
                this.putValue("SmallIcon", ImageProvider.get((String)WikosmDownloadSourcePanel.ACTION_IMG_SUBDIR, (String)"add"));
                this.putValue("ShortDescription", I18n.tr((String)"Add new snippet", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                WikosmDownloadSourcePanel.this.wikosmQueryList.createNewItem();
            }
        }
    }
}

