/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.DefaultTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.SearchTextResultListPanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class WikosmQueryList
extends SearchTextResultListPanel<SelectorItem> {
    private static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss, dd-MM-yyyy");
    private final JTextComponent target;
    private final Component componentParent;
    private final transient Map<String, SelectorItem> items;
    private static final String KEY_KEY = "key";
    private static final String QUERY_KEY = "query";
    private static final String LAST_EDIT_KEY = "lastEdit";
    private static final String PREFERENCE_ITEMS = "download.wikosm.query";
    private static final String TRANSLATED_HISTORY = I18n.tr((String)"history", (Object[])new Object[0]);

    public WikosmQueryList(Component parent, JTextComponent target) {
        this.target = target;
        this.componentParent = parent;
        this.items = WikosmQueryList.restorePreferences();
        WikosmQueryListMouseAdapter mouseHandler = new WikosmQueryListMouseAdapter(this.lsResult, (SearchTextResultListPanel.ResultListModel<SelectorItem>)this.lsResultModel);
        this.lsResult.setCellRenderer(new WikosmQueryCellRendered());
        super.setDblClickListener(e -> this.doubleClickEvent());
        this.lsResult.addMouseListener(mouseHandler);
        this.lsResult.addMouseMotionListener(mouseHandler);
        this.filterItems();
    }

    public synchronized Optional<SelectorItem> getSelectedItem() {
        int idx = this.lsResult.getSelectedIndex();
        if (this.lsResultModel.getSize() <= idx || idx == -1) {
            return Optional.empty();
        }
        SelectorItem item = (SelectorItem)this.lsResultModel.getElementAt(idx);
        this.filterItems();
        return Optional.of(item);
    }

    public synchronized void saveHistoricItem(String query) {
        boolean historicExist = this.items.values().stream().map(SelectorItem::getQuery).anyMatch(q -> q.equals(query));
        if (!historicExist) {
            SelectorItem item = new SelectorItem(TRANSLATED_HISTORY + " " + LocalDateTime.now().format(FORMAT), query);
            this.items.put(item.getKey(), item);
            this.savePreferences();
            this.filterItems();
        }
    }

    public synchronized void removeSelectedItem() {
        Optional<SelectorItem> it = this.getSelectedItem();
        if (!it.isPresent()) {
            JOptionPane.showMessageDialog(this.componentParent, I18n.tr((String)"Please select an item first", (Object[])new Object[0]));
            return;
        }
        SelectorItem item = it.get();
        if (this.items.remove(item.getKey(), item)) {
            this.clearSelection();
            this.savePreferences();
            this.filterItems();
        }
    }

    public synchronized void editSelectedItem() {
        Optional<SelectorItem> it = this.getSelectedItem();
        if (!it.isPresent()) {
            JOptionPane.showMessageDialog(this.componentParent, I18n.tr((String)"Please select an item first", (Object[])new Object[0]));
            return;
        }
        SelectorItem item = it.get();
        EditItemDialog dialog = new EditItemDialog(this.componentParent, I18n.tr((String)"Edit item", (Object[])new Object[0]), item, I18n.tr((String)"Save", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0]));
        dialog.showDialog();
        Optional<SelectorItem> editedItem = dialog.getOutputItem();
        editedItem.ifPresent(i -> {
            this.items.remove(item.getKey(), item);
            this.items.put(i.getKey(), (SelectorItem)i);
            this.savePreferences();
            this.filterItems();
        });
    }

    public synchronized void createNewItem() {
        EditItemDialog dialog = new EditItemDialog(this.componentParent, I18n.tr((String)"Add snippet", (Object[])new Object[0]), I18n.tr((String)"Add", (Object[])new Object[0]));
        dialog.showDialog();
        Optional<SelectorItem> newItem = dialog.getOutputItem();
        newItem.ifPresent(i -> {
            this.items.put(i.getKey(), (SelectorItem)i);
            this.savePreferences();
            this.filterItems();
        });
    }

    public void setDblClickListener(ActionListener dblClickListener) {
    }

    protected void filterItems() {
        String text = this.edSearchText.getText().toLowerCase(Locale.ENGLISH);
        List matchingItems = this.items.values().stream().sorted((i1, i2) -> i2.getLastEdit().compareTo(i1.getLastEdit())).filter(item -> item.getKey().contains(text)).collect(Collectors.toList());
        this.lsResultModel.setItems(matchingItems);
    }

    private void doubleClickEvent() {
        Optional<SelectorItem> selectedItem = this.getSelectedItem();
        if (!selectedItem.isPresent()) {
            return;
        }
        SelectorItem item = selectedItem.get();
        this.target.setText(item.getQuery());
    }

    private void savePreferences() {
        ArrayList toSave = new ArrayList(this.items.size());
        for (SelectorItem item : this.items.values()) {
            HashMap<String, String> it = new HashMap<String, String>();
            it.put(KEY_KEY, item.getKey());
            it.put(QUERY_KEY, item.getQuery());
            it.put(LAST_EDIT_KEY, item.getLastEdit().format(FORMAT));
            toSave.add(it);
        }
        Config.getPref().putListOfMaps(PREFERENCE_ITEMS, toSave);
    }

    private static Map<String, SelectorItem> restorePreferences() {
        List toRetrieve = Config.getPref().getListOfMaps(PREFERENCE_ITEMS, Collections.emptyList());
        HashMap<String, SelectorItem> result = new HashMap<String, SelectorItem>();
        for (Map entry : toRetrieve) {
            try {
                String key = (String)entry.get(KEY_KEY);
                String query = (String)entry.get(QUERY_KEY);
                String lastEditText = (String)entry.get(LAST_EDIT_KEY);
                LocalDateTime lastEdit = lastEditText == null ? LocalDateTime.MIN : LocalDateTime.parse(lastEditText, FORMAT);
                result.put(key, new SelectorItem(key, query, lastEdit));
            }
            catch (IllegalArgumentException | DateTimeParseException e) {
                Logging.error((Throwable)e);
            }
        }
        return result;
    }

    public static class SelectorItem {
        private final String itemKey;
        private final String query;
        private final LocalDateTime lastEdit;

        public SelectorItem(String key, String query) {
            this(key, query, LocalDateTime.now());
        }

        public SelectorItem(String key, String query, LocalDateTime lastEdit) {
            Objects.requireNonNull(key, "The name of the item cannot be null");
            Objects.requireNonNull(query, "The query of the item cannot be null");
            Objects.requireNonNull(lastEdit, "The last edit date time cannot be null");
            if (Utils.isStripEmpty((String)key)) {
                throw new IllegalArgumentException("The key of the item cannot be empty");
            }
            if (Utils.isStripEmpty((String)query)) {
                throw new IllegalArgumentException("The query cannot be empty");
            }
            this.itemKey = key;
            this.query = query;
            this.lastEdit = lastEdit;
        }

        public String getKey() {
            return this.itemKey;
        }

        public String getQuery() {
            return this.query;
        }

        public LocalDateTime getLastEdit() {
            return this.lastEdit;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.itemKey == null ? 0 : this.itemKey.hashCode());
            result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SelectorItem other = (SelectorItem)obj;
            if (this.itemKey == null ? other.itemKey != null : !this.itemKey.equals(other.itemKey)) {
                return false;
            }
            return !(this.query == null ? other.query != null : !this.query.equals(other.query));
        }
    }

    private final class EditItemDialog
    extends ExtendedDialog {
        private final JTextField name;
        private final JosmTextArea query;
        private final transient AbstractTextComponentValidator queryValidator;
        private final transient AbstractTextComponentValidator nameValidator;
        private static final int SUCCESS_BTN = 0;
        private static final int CANCEL_BTN = 1;
        private final transient SelectorItem itemToEdit;
        private transient Optional<SelectorItem> outputItem;

        EditItemDialog(Component parent, String title, String ... buttonTexts) {
            this(parent, title, (SelectorItem)null, buttonTexts);
        }

        EditItemDialog(Component parent, String title, SelectorItem itemToEdit, String ... buttonTexts) {
            super(parent, title, buttonTexts);
            this.outputItem = Optional.empty();
            this.itemToEdit = itemToEdit;
            final String nameToEdit = itemToEdit == null ? "" : itemToEdit.getKey();
            String queryToEdit = itemToEdit == null ? "" : itemToEdit.getQuery();
            this.name = new JTextField(nameToEdit);
            this.query = new JosmTextArea(queryToEdit);
            this.queryValidator = new DefaultTextComponentValidator((JTextComponent)this.query, "", I18n.tr((String)"Query cannot be empty", (Object[])new Object[0]));
            this.nameValidator = new AbstractTextComponentValidator(this.name){

                public void validate() {
                    if (this.isValid()) {
                        this.feedbackValid(I18n.tr((String)"This name can be used for the item", (Object[])new Object[0]));
                    } else {
                        this.feedbackInvalid(I18n.tr((String)"Item with this name already exists", (Object[])new Object[0]));
                    }
                }

                public boolean isValid() {
                    String currentName = EditItemDialog.this.name.getText();
                    boolean notEmpty = !Utils.isStripEmpty((String)currentName);
                    boolean exist = !currentName.equals(nameToEdit) && WikosmQueryList.this.items.containsKey(currentName);
                    return notEmpty && !exist;
                }
            };
            this.name.getDocument().addDocumentListener((DocumentListener)this.nameValidator);
            this.query.getDocument().addDocumentListener((DocumentListener)this.queryValidator);
            JPanel panel = new JPanel(new GridBagLayout());
            JScrollPane queryScrollPane = GuiHelper.embedInVerticalScrollPane((Component)this.query);
            queryScrollPane.getVerticalScrollBar().setUnitIncrement(10);
            GBC constraint = GBC.eol().insets(8, 0, 8, 8).anchor(10).fill(2);
            constraint.ipady = 250;
            panel.add((Component)this.name, GBC.eol().insets(5).anchor(14).fill(2));
            panel.add((Component)queryScrollPane, constraint);
            this.setDefaultButton(1);
            this.setCancelButton(new Integer[]{2});
            this.setPreferredSize(new Dimension(400, 400));
            this.setContent(panel, false);
        }

        public Optional<SelectorItem> getOutputItem() {
            return this.outputItem;
        }

        protected void buttonAction(int buttonIndex, ActionEvent evt) {
            if (buttonIndex == 0) {
                if (!this.nameValidator.isValid()) {
                    JOptionPane.showMessageDialog(WikosmQueryList.this.componentParent, I18n.tr((String)"The item cannot be created with provided name", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                    return;
                }
                if (!this.queryValidator.isValid()) {
                    JOptionPane.showMessageDialog(WikosmQueryList.this.componentParent, I18n.tr((String)"The item cannot be created with an empty query", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                    return;
                }
                if (this.itemToEdit != null) {
                    String newKey = this.name.getText();
                    String newQuery = this.query.getText();
                    String itemKey = this.itemToEdit.getKey();
                    String itemQuery = this.itemToEdit.getQuery();
                    this.outputItem = Optional.of(new SelectorItem(this.name.getText(), this.query.getText(), !newKey.equals(itemKey) || !newQuery.equals(itemQuery) ? LocalDateTime.now() : this.itemToEdit.getLastEdit()));
                } else {
                    this.outputItem = Optional.of(new SelectorItem(this.name.getText(), this.query.getText()));
                }
            }
            super.buttonAction(buttonIndex, evt);
        }
    }

    private static class WikosmQueryCellRendered
    extends JLabel
    implements ListCellRenderer<SelectorItem> {
        WikosmQueryCellRendered() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SelectorItem> list, SelectorItem value, int index, boolean isSelected, boolean cellHasFocus) {
            Font font = list.getFont();
            if (isSelected) {
                this.setFont(new Font(font.getFontName(), 1, font.getSize() + 2));
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setFont(new Font(font.getFontName(), 0, font.getSize() + 2));
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setText(value.getKey());
            if (isSelected && cellHasFocus) {
                this.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(2, 0, 2, 0)));
            } else {
                this.setBorder(new CompoundBorder(null, BorderFactory.createEmptyBorder(2, 0, 2, 0)));
            }
            return this;
        }
    }

    private class WikosmQueryListMouseAdapter
    extends MouseAdapter {
        private final JList<SelectorItem> list;
        private final SearchTextResultListPanel.ResultListModel<SelectorItem> model;
        private final JPopupMenu emptySelectionPopup = new JPopupMenu();
        private final JPopupMenu elementPopup = new JPopupMenu();

        WikosmQueryListMouseAdapter(JList<SelectorItem> list, SearchTextResultListPanel.ResultListModel<SelectorItem> listModel) {
            this.list = list;
            this.model = listModel;
            this.initPopupMenus();
        }

        private int locationToIndex(Point p) {
            int idx = this.list.locationToIndex(p);
            if (idx != -1 && !this.list.getCellBounds(idx, idx).contains(p)) {
                return -1;
            }
            return idx;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (SwingUtilities.isRightMouseButton(e)) {
                int index = this.locationToIndex(e.getPoint());
                if (this.model.getSize() == 0 || index == -1) {
                    this.list.clearSelection();
                    this.emptySelectionPopup.show(this.list, e.getX(), e.getY());
                } else {
                    this.list.setSelectedIndex(index);
                    this.list.ensureIndexIsVisible(index);
                    this.elementPopup.show(this.list, e.getX(), e.getY());
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            int idx = this.locationToIndex(e.getPoint());
            if (idx == -1) {
                return;
            }
            SelectorItem item = (SelectorItem)this.model.getElementAt(idx);
            this.list.setToolTipText("<html><pre style='width:300px;'>" + Utils.escapeReservedCharactersHTML((String)Utils.restrictStringLines((String)item.getQuery(), (int)9)));
        }

        private void initPopupMenus() {
            AbstractAction add = new AbstractAction(I18n.tr((String)"Add", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WikosmQueryList.this.createNewItem();
                }
            };
            AbstractAction edit = new AbstractAction(I18n.tr((String)"Edit", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WikosmQueryList.this.editSelectedItem();
                }
            };
            AbstractAction remove = new AbstractAction(I18n.tr((String)"Remove", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WikosmQueryList.this.removeSelectedItem();
                }
            };
            this.emptySelectionPopup.add(add);
            this.elementPopup.add(add);
            this.elementPopup.add(edit);
            this.elementPopup.add(remove);
        }
    }
}

