/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.gui;

import java.awt.Component;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class GuiUtils {
    public static final String PREF_OVERWRITE = "wikipedia.overwrite-tag";

    public static boolean confirmOverwrite(String key, String newValue, Collection<OsmPrimitive> primitives) {
        SortedSet existingValues = primitives.stream().map(x -> x.get(key)).filter(x -> x != null && !newValue.equals(x)).collect(Collectors.toCollection(() -> new TreeSet(AlphanumComparator.getInstance())));
        if (existingValues.isEmpty()) {
            return true;
        }
        Boolean r = (Boolean)GuiHelper.runInEDTAndWaitAndReturn(() -> ConditionalOptionPaneUtil.showConfirmationDialog((String)PREF_OVERWRITE, (Component)Main.parent, (Object)I18n.trn((String)"Overwrite ''{0}'' tag {1} from {2} with new value ''{3}''?", (String)"Overwrite ''{0}'' tags {1} from {2} with new value ''{3}''?", (long)existingValues.size(), (Object[])new Object[]{key, Utils.joinAsHtmlUnorderedList((Iterable)existingValues), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(primitives, 10), newValue}), (String)I18n.tr((String)"Overwrite key", (Object[])new Object[0]), (int)0, (int)3, (int)0));
        return Boolean.TRUE.equals(r);
    }
}

