/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.modules;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleException;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;

public class ModuleInformation {
    public File file = null;
    public String name = null;
    public String className = null;
    public String link = null;
    public String description = null;
    public String author = null;
    public String version = null;
    public String localversion = null;
    public String downloadlink = null;
    public String iconPath;
    public ImageIcon icon;
    public List<URL> libraries = new LinkedList<URL>();
    public final Map<String, String> attr = new TreeMap<String, String>();

    public ModuleInformation(File file, String name) throws ModuleException {
        this.name = name;
        this.file = file;
        try (FileInputStream fis = new FileInputStream(file);
             JarInputStream jar = new JarInputStream(fis);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                throw new ModuleException(name, I18n.tr((String)"The module file ''{0}'' does not include a Manifest.", (Object[])new Object[]{file.toString()}));
            }
            this.scanManifest(manifest);
            this.libraries.add(0, ModuleInformation.fileToURL(file));
        }
        catch (IOException e) {
            throw new ModuleException(name, e);
        }
    }

    public ModuleInformation(InputStream manifestStream, String name, String url) throws ModuleException {
        this.name = name;
        try {
            Manifest manifest = new Manifest();
            manifest.read(manifestStream);
            if (url != null) {
                this.downloadlink = url;
            }
            this.scanManifest(manifest);
        }
        catch (IOException e) {
            throw new ModuleException(name, e);
        }
    }

    public void updateFromModuleSite(ModuleInformation other) {
        this.className = other.className;
        this.link = other.link;
        this.description = other.description;
        this.author = other.author;
        this.version = other.version;
        this.downloadlink = other.downloadlink;
        this.icon = other.icon;
        this.iconPath = other.iconPath;
        this.libraries = other.libraries;
        this.attr.clear();
        this.attr.putAll(other.attr);
    }

    private static ImageIcon extractIcon(String iconPath, File jarFile, boolean suppressWarnings) {
        return new ImageProvider(iconPath).setArchive(jarFile).setMaxWidth(24).setMaxHeight(24).setOptional(true).setSuppressWarnings(suppressWarnings).get();
    }

    private void scanManifest(Manifest manifest) {
        String classPath;
        String lang = LanguageInfo.getLanguageCodeManifest();
        Attributes attr = manifest.getMainAttributes();
        this.className = attr.getValue("Module-Class");
        String s = attr.getValue(lang + "Module-Link");
        if (s == null) {
            s = attr.getValue("Module-Link");
        }
        if (s != null) {
            try {
                URL uRL = new URL(s);
            }
            catch (MalformedURLException e) {
                Logging.error((String)I18n.tr((String)"Invalid URL ''{0}'' in module {1}", (Object[])new Object[]{s, this.name}));
                s = null;
            }
        }
        this.link = s;
        s = attr.getValue(lang + "Module-Description");
        if (s == null && (s = attr.getValue("Module-Description")) != null) {
            s = I18n.tr((String)s, (Object[])new Object[0]);
        }
        this.description = s;
        this.version = attr.getValue("Module-Version");
        this.author = attr.getValue("Author");
        this.iconPath = attr.getValue("Module-Icon");
        if (this.iconPath != null && this.file != null) {
            this.icon = ModuleInformation.extractIcon(this.iconPath, this.file, true);
            if (this.icon == null) {
                this.icon = ModuleInformation.extractIcon(this.iconPath, OdPlugin.getInstance().getPluginInformation().file, true);
            }
            if (this.icon == null) {
                Logging.error((String)("Unable to load module icon: " + this.iconPath));
            }
        }
        if ((classPath = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
            for (String entry : classPath.split(" ")) {
                File entryFile = new File(entry).isAbsolute() || this.file == null ? new File(entry) : new File(this.file.getParent(), entry);
                this.libraries.add(ModuleInformation.fileToURL(entryFile));
            }
        }
        for (Object e : attr.keySet()) {
            this.attr.put(e.toString(), attr.getValue(e.toString()));
        }
    }

    public String getDescriptionAsHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append(this.description == null ? I18n.tr((String)"no description available", (Object[])new Object[0]) : this.description);
        if (this.link != null) {
            sb.append(" <a href=\"").append(this.link).append("\">").append(I18n.tr((String)"More info...", (Object[])new Object[0])).append("</a>");
        }
        if (this.downloadlink != null && !this.downloadlink.startsWith("http://svn.openstreetmap.org/applications/editors/josm/plugins/opendata/dist/")) {
            sb.append("<p>&nbsp;</p><p>" + I18n.tr((String)"<b>Module provided by an external source:</b> {0}", (Object[])new Object[]{this.downloadlink}) + "</p>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public Module load(Class<? extends Module> klass) throws ModuleException {
        try {
            return klass.getConstructor(ModuleInformation.class).newInstance(this);
        }
        catch (Exception t) {
            throw new ModuleException(this.name, t);
        }
    }

    public Class<? extends Module> loadClass(ClassLoader classLoader) throws ModuleException {
        if (this.className == null) {
            return null;
        }
        try {
            return Class.forName(this.className, true, classLoader);
        }
        catch (Exception t) {
            throw new ModuleException(this.name, t);
        }
    }

    public static URL fileToURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            Logging.warn((String)ex.getMessage());
            return null;
        }
    }

    public static Collection<String> getModuleLocations() {
        Collection locations = Main.pref.getAllPossiblePreferenceDirs();
        ArrayList<String> all = new ArrayList<String>(locations.size());
        for (String s : locations) {
            all.add(s + "plugins/opendata/modules");
        }
        return all;
    }

    public boolean isUpdateRequired(String referenceVersion) {
        if (this.downloadlink == null) {
            return false;
        }
        if (this.version == null && referenceVersion != null) {
            return true;
        }
        return this.version != null && !this.version.equals(referenceVersion);
    }

    public boolean isUpdateRequired() {
        if (this.downloadlink == null) {
            return false;
        }
        if (this.localversion == null) {
            return true;
        }
        return this.isUpdateRequired(this.localversion);
    }

    protected boolean matches(String filter, String value) {
        if (filter == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.toLowerCase().contains(filter.toLowerCase());
    }

    public boolean matches(String filter) {
        String[] words;
        if (filter == null) {
            return true;
        }
        for (String word : words = filter.split("\\s+")) {
            if (!this.matches(word, this.name) && !this.matches(word, this.description) && !this.matches(word, this.version) && !this.matches(word, this.localversion)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public ImageIcon getScaledIcon() {
        Dimension dim = ImageProvider.ImageSizes.MENU.getImageDimension();
        ImageIcon iconToScale = this.icon != null ? this.icon : OdUtils.getImageIcon("empty24.png");
        return new ImageIcon(iconToScale.getImage().getScaledInstance(dim.width, dim.height, 4));
    }
}

