/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.POIDocument;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class HSSFWorkbook
extends POIDocument
implements Workbook {
    public static final int INITIAL_CAPACITY = 3;
    private InternalWorkbook workbook;
    protected List<HSSFSheet> _sheets;
    private ArrayList<HSSFName> names;
    private Row.MissingCellPolicy missingCellPolicy = HSSFRow.RETURN_NULL_AND_BLANK;
    private static POILogger log = POILogFactory.getLogger(HSSFWorkbook.class);
    private static final String[] WORKBOOK_DIR_ENTRY_NAMES = new String[]{"Workbook", "WORKBOOK"};

    private HSSFWorkbook(InternalWorkbook internalWorkbook) {
        super(null);
        this.workbook = internalWorkbook;
        this._sheets = new ArrayList<HSSFSheet>(3);
        this.names = new ArrayList(3);
    }

    public HSSFWorkbook(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem, true);
    }

    public HSSFWorkbook(POIFSFileSystem pOIFSFileSystem, boolean bl) throws IOException {
        this(pOIFSFileSystem.getRoot(), pOIFSFileSystem, bl);
    }

    private static String getWorkbookDirEntryName(DirectoryNode directoryNode) {
        String[] stringArray = WORKBOOK_DIR_ENTRY_NAMES;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                directoryNode.getEntry(string);
                return string;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
        }
        try {
            directoryNode.getEntry("Book");
            throw new OldExcelFormatException("The supplied spreadsheet seems to be Excel 5.0/7.0 (BIFF5) format. POI only supports BIFF8 format (from Excel versions 97/2000/XP/2003)");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("The supplied POIFSFileSystem does not contain a BIFF8 'Workbook' entry. Is it really an excel file?");
        }
    }

    public HSSFWorkbook(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem, boolean bl) throws IOException {
        super(directoryNode);
        String string = HSSFWorkbook.getWorkbookDirEntryName(directoryNode);
        if (!bl) {
            this.directory = null;
        }
        this._sheets = new ArrayList<HSSFSheet>(3);
        this.names = new ArrayList(3);
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream(string);
        List<Record> list = RecordFactory.createRecords(documentInputStream);
        this.workbook = InternalWorkbook.createWorkbook(list);
        this.setPropertiesFromWorkbook(this.workbook);
        int n = this.workbook.getNumRecords();
        this.convertLabelRecords(list, n);
        RecordStream recordStream = new RecordStream(list, n);
        while (recordStream.hasNext()) {
            InternalSheet internalSheet = InternalSheet.createSheet(recordStream);
            this._sheets.add(new HSSFSheet(this, internalSheet));
        }
        for (int i = 0; i < this.workbook.getNumNames(); ++i) {
            NameRecord nameRecord = this.workbook.getNameRecord(i);
            HSSFName hSSFName = new HSSFName(this, nameRecord);
            this.names.add(hSSFName);
        }
    }

    private void setPropertiesFromWorkbook(InternalWorkbook internalWorkbook) {
        this.workbook = internalWorkbook;
    }

    private void convertLabelRecords(List<Record> list, int n) {
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "convertLabelRecords called");
        }
        for (int i = n; i < list.size(); ++i) {
            Record record = list.get(i);
            if (record.getSid() != 516) continue;
            LabelRecord labelRecord = (LabelRecord)record;
            list.remove(i);
            LabelSSTRecord labelSSTRecord = new LabelSSTRecord();
            int n2 = this.workbook.addSSTString(new UnicodeString(labelRecord.getValue()));
            labelSSTRecord.setRow(labelRecord.getRow());
            labelSSTRecord.setColumn(labelRecord.getColumn());
            labelSSTRecord.setXFIndex(labelRecord.getXFIndex());
            labelSSTRecord.setSSTIndex(n2);
            list.add(i, labelSSTRecord);
        }
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "convertLabelRecords exit");
        }
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this.missingCellPolicy;
    }

    private void validateSheetIndex(int n) {
        int n2 = this._sheets.size() - 1;
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Sheet index (" + n + ") is out of range (0.." + n2 + ")");
        }
    }

    public int getNumberOfSheets() {
        return this._sheets.size();
    }

    @Override
    public HSSFSheet getSheetAt(int n) {
        this.validateSheetIndex(n);
        return this._sheets.get(n);
    }

    public HSSFSheet getSheet(String string) {
        HSSFSheet hSSFSheet = null;
        for (int i = 0; i < this._sheets.size(); ++i) {
            String string2 = this.workbook.getSheetName(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            hSSFSheet = this._sheets.get(i);
        }
        return hSSFSheet;
    }

    InternalWorkbook getWorkbook() {
        return this.workbook;
    }
}

