/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class TabFiles
extends ShpFiles {
    private final Map<ShpFileType, URL> urls;

    public TabFiles(File headerFile, File dataFile) throws IllegalArgumentException {
        super(TabFiles.fakeShpFile(headerFile));
        try {
            Field furls = ShpFiles.class.getDeclaredField("urls");
            Utils.setObjectsAccessible((AccessibleObject[])new AccessibleObject[]{furls});
            this.urls = (Map)furls.get((Object)this);
        }
        catch (ReflectiveOperationException e) {
            throw new JosmRuntimeException((Throwable)e);
        }
        this.init(DataUtilities.fileToURL((File)headerFile));
        this.urls.put(ShpFileType.DBF, DataUtilities.fileToURL((File)dataFile));
    }

    private static URL fakeShpFile(File headerFile) {
        return DataUtilities.fileToURL((File)new File(headerFile.getAbsolutePath() + ".shp"));
    }

    private String baseName(Object obj) {
        if (obj instanceof URL) {
            return this.toBase(((URL)obj).toExternalForm());
        }
        return null;
    }

    private String toBase(String path) {
        return path.substring(0, path.toLowerCase().lastIndexOf(".tab"));
    }

    private void init(URL url) {
        String base = this.baseName(url);
        if (base == null) {
            throw new IllegalArgumentException(url.getPath() + " is not one of the files types that is known to be associated with a MapInfo TAB file");
        }
        String urlString = url.toExternalForm();
        char lastChar = urlString.charAt(urlString.length() - 1);
        boolean upperCase = Character.isUpperCase(lastChar);
        for (ShpFileType type : ShpFileType.values()) {
            URL newURL;
            String extensionWithPeriod = type.extensionWithPeriod;
            extensionWithPeriod = upperCase ? extensionWithPeriod.toUpperCase() : extensionWithPeriod.toLowerCase();
            String string = base + extensionWithPeriod;
            try {
                newURL = new URL(url, string);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.urls.put(type, newURL);
        }
        if (this.isLocal()) {
            Set<Map.Entry<ShpFileType, URL>> entries = this.urls.entrySet();
            HashMap<ShpFileType, URL> toUpdate = new HashMap<ShpFileType, URL>();
            for (Map.Entry<ShpFileType, URL> entry : entries) {
                if (this.exists(entry.getKey()) || (url = this.findExistingFile(entry.getKey(), entry.getValue())) == null) continue;
                toUpdate.put(entry.getKey(), url);
            }
            this.urls.putAll(toUpdate);
        }
    }

    private URL findExistingFile(ShpFileType shpFileType, URL value) {
        File[] files;
        File file = DataUtilities.urlToFile((URL)value);
        File directory = file.getParentFile();
        if (directory != null && directory.exists() && (files = directory.listFiles((dir, name) -> file.getName().equalsIgnoreCase(name))).length > 0) {
            try {
                return files[0].toURI().toURL();
            }
            catch (MalformedURLException e) {
                Logging.error((Throwable)e);
            }
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public String getTypeName() {
        int slash;
        String path = ShpFileType.SHP.toBase(this.urls.get(ShpFileType.SHP));
        int dot = path.indexOf(46, slash = Math.max(0, path.lastIndexOf(47) + 1));
        if (dot < 0) {
            dot = path.length();
        }
        return path.substring(slash, dot);
    }
}

