/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.EntryNode;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyTable;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.HeaderBlockReader;
import org.apache.poi.poifs.storage.RawDataBlockList;
import org.apache.poi.poifs.storage.SmallBlockTableReader;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class POIFSFileSystem {
    private static final POILogger _logger = POILogFactory.getLogger(POIFSFileSystem.class);
    private PropertyTable _property_table;
    private List<POIFSDocument> _documents;
    private DirectoryNode _root = null;
    private POIFSBigBlockSize bigBlockSize = POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;

    public POIFSFileSystem() {
        this._property_table = new PropertyTable();
        this._documents = new ArrayList<POIFSDocument>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POIFSFileSystem(InputStream inputStream) throws IOException {
        this();
        RawDataBlockList rawDataBlockList;
        HeaderBlockReader headerBlockReader;
        boolean bl = false;
        try {
            headerBlockReader = new HeaderBlockReader(inputStream);
            this.bigBlockSize = headerBlockReader.getBigBlockSize();
            rawDataBlockList = new RawDataBlockList(inputStream, this.bigBlockSize);
            bl = true;
        }
        finally {
            this.closeInputStream(inputStream, bl);
        }
        new BlockAllocationTableReader(headerBlockReader.getBigBlockSize(), headerBlockReader.getBATCount(), headerBlockReader.getBATArray(), headerBlockReader.getXBATCount(), headerBlockReader.getXBATIndex(), rawDataBlockList);
        PropertyTable propertyTable = new PropertyTable(headerBlockReader.getPropertyStart(), rawDataBlockList);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(this.bigBlockSize, rawDataBlockList, propertyTable.getRoot(), headerBlockReader.getSBATStart()), rawDataBlockList, propertyTable.getRoot().getChildren(), null, headerBlockReader.getPropertyStart());
        this.getRoot().setStorageClsid(propertyTable.getRoot().getStorageClsid());
    }

    private void closeInputStream(InputStream inputStream, boolean bl) {
        if (inputStream.markSupported() && !(inputStream instanceof ByteArrayInputStream)) {
            String string = "POIFS is closing the supplied input stream of type (" + inputStream.getClass().getName() + ") which supports mark/reset.  This will be a problem for the caller if the stream will still be used.  If that is the case the caller should wrap the input stream to avoid this close logic.  This warning is only temporary and will not be present in future versions of POI.";
            _logger.log(POILogger.WARN, string);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            if (bl) {
                throw new RuntimeException(iOException);
            }
            iOException.printStackTrace();
        }
    }

    public DirectoryNode getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode(this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    void addDocument(POIFSDocument pOIFSDocument) {
        this._documents.add(pOIFSDocument);
        this._property_table.addProperty(pOIFSDocument.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directoryProperty) {
        this._property_table.addProperty(directoryProperty);
    }

    void remove(EntryNode entryNode) {
        this._property_table.removeProperty(entryNode.getProperty());
        if (entryNode.isDocumentEntry()) {
            this._documents.remove(((DocumentNode)entryNode).getDocument());
        }
    }

    private void processProperties(BlockList blockList, BlockList blockList2, Iterator<Property> iterator, DirectoryNode directoryNode, int n) throws IOException {
        while (iterator.hasNext()) {
            DirectoryNode directoryNode2;
            Property property = iterator.next();
            String string = property.getName();
            DirectoryNode directoryNode3 = directoryNode2 = directoryNode == null ? this.getRoot() : directoryNode;
            if (property.isDirectory()) {
                DirectoryNode directoryNode4 = (DirectoryNode)directoryNode2.createDirectory(string);
                directoryNode4.setStorageClsid(property.getStorageClsid());
                this.processProperties(blockList, blockList2, ((DirectoryProperty)property).getChildren(), directoryNode4, n);
                continue;
            }
            int n2 = property.getStartBlock();
            int n3 = property.getSize();
            POIFSDocument pOIFSDocument = null;
            pOIFSDocument = property.shouldUseSmallBlocks() ? new POIFSDocument(string, blockList.fetchBlocks(n2, n), n3) : new POIFSDocument(string, blockList2.fetchBlocks(n2, n), n3);
            directoryNode2.createDocument(pOIFSDocument);
        }
    }
}

