/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;

public class JPanelTextField
extends JTextField {
    private final KeyStroke[] standardKeys;
    private static final int MODIFIERS_MASK = 960;

    public JPanelTextField() {
        this.setFocusTraversalKeys(0, new HashSet());
        PopupMenuLauncher launcher = new PopupMenuLauncher(this.createEditMenu());
        this.addMouseListener((MouseListener)launcher);
        this.standardKeys = this.getInputMap(0).allKeys();
    }

    private JPopupMenu createEditMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.createMenuItem("cut-to-clipboard", I18n.tr((String)"Cut", (Object[])new Object[0])));
        menu.add(this.createMenuItem("copy-to-clipboard", I18n.tr((String)"Copy", (Object[])new Object[0])));
        menu.add(this.createMenuItem("paste-from-clipboard", I18n.tr((String)"Paste", (Object[])new Object[0])));
        menu.add(this.createMenuItem("select-all", I18n.tr((String)"Select All", (Object[])new Object[0])));
        return menu;
    }

    private JMenuItem createMenuItem(String action, String label) {
        JMenuItem item = new JMenuItem(this.getActionMap().get(action));
        item.setText(label);
        return item;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            String text;
            int code = e.getKeyCode();
            if (code == 10) {
                text = this.getText();
                if (text.length() > 0) {
                    this.processEnter(text);
                    this.setText("");
                }
            } else if (code == 9) {
                int start;
                text = this.getText();
                int caret = this.getCaretPosition();
                for (start = caret - 1; start >= 0 && Character.isJavaIdentifierPart(text.charAt(start)); --start) {
                }
                if (++start < caret) {
                    String complete;
                    String word = text.substring(start, caret);
                    String string = word == null ? null : (complete = this.autoComplete(word, start == 0));
                    if (complete != null && !complete.equals(word)) {
                        StringBuilder sb = new StringBuilder();
                        if (start > 0) {
                            sb.append(text.substring(0, start));
                        }
                        sb.append(complete);
                        if (caret < text.length()) {
                            sb.append(text.substring(caret));
                        }
                        this.setText(sb.toString());
                        this.setCaretPosition(start + complete.length());
                    }
                }
            } else if (code == 27 && MainApplication.isDisplayingMapView()) {
                MainApplication.getMap().mapView.requestFocus();
            }
            boolean keyIsStandard = false;
            for (KeyStroke ks : this.standardKeys) {
                if (code != ks.getKeyCode() || (e.getModifiersEx() & 0x3C0) != (ks.getModifiers() & 0x3C0)) continue;
                keyIsStandard = true;
                break;
            }
            if (!keyIsStandard) {
                e.consume();
            }
        }
        super.processKeyEvent(e);
    }

    protected void processEnter(String text) {
    }

    protected String autoComplete(String word, boolean atStart) {
        return word;
    }
}

