/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix;

import java.text.DecimalFormat;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.tofix.TofixDraw;
import org.openstreetmap.josm.plugins.tofix.TofixLayer;
import org.openstreetmap.josm.plugins.tofix.bean.AccessToTask;
import org.openstreetmap.josm.plugins.tofix.bean.items.Item;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintLinestring;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintMultilinestring;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintMultipoint;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintMultipolygon;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintPoint;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintPolygon;
import org.openstreetmap.josm.plugins.tofix.controller.ItemController;
import org.openstreetmap.josm.plugins.tofix.util.Download;
import org.openstreetmap.josm.tools.I18n;

public class TofixTask {
    ItemController itemController = new ItemController();
    Bounds bounds = null;
    Bounds bounds_default = null;
    Node node = null;
    MapView mv = null;
    TofixLayer tofixLayer = new TofixLayer("Tofix-layer");

    public AccessToTask work(Item item, AccessToTask accessToTask, double size, JsonArray relation) {
        if ("Point".equals(item.getType())) {
            accessToTask = this.work_osmlintpoint(item.getItemOsmlintPoint(), accessToTask, size);
        }
        if ("LineString".equals(item.getType())) {
            accessToTask = this.work_osmlintlinestring(item.getItemOsmlintLinestring(), accessToTask, size);
        }
        if ("MultiPoint".equals(item.getType())) {
            accessToTask = this.work_osmlintmultipoint(item.getItemOsmlintMultipoint(), accessToTask, size);
        }
        if ("MultiLineString".equals(item.getType())) {
            accessToTask = this.work_osmlintmultilinestring(item.getItemOsmlintMultilinestring(), accessToTask, size);
        }
        if ("Polygon".equals(item.getType())) {
            accessToTask = this.work_osmlintpolygon(item.getItemOsmlintPolygon(), accessToTask, size, relation);
        }
        if ("MultiPolygon".equals(item.getType())) {
            accessToTask = this.work_osmlintmultipolygon(item.getItemOsmlintMultipolygon(), accessToTask, size);
        }
        UploadDialog.getUploadDialog().getChangeset().getCommentsCount();
        return accessToTask;
    }

    private AccessToTask work_osmlintpoint(ItemOsmlintPoint itemOsmlintPoint, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintPoint.getKey());
        this.node = itemOsmlintPoint.get_node();
        this.bounds = new Bounds(itemOsmlintPoint.getRectangle2D());
        this.bounds_default = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        if (this.bounds.getArea() < this.bounds_default.getArea()) {
            this.bounds = this.bounds_default;
        }
        this.checkTofixLayer();
        TofixDraw.draw_Node(this.tofixLayer, this.node.getCoor());
        Download.download(this.bounds, itemOsmlintPoint.getWay());
        return accessToTask;
    }

    private AccessToTask work_osmlintlinestring(ItemOsmlintLinestring itemOsmlintLinestring, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintLinestring.getKey());
        List<List<Node>> list = itemOsmlintLinestring.get_nodes();
        this.node = new Node(new LatLon(list.get(0).get(0).getCoor().lat(), list.get(0).get(0).getCoor().lon()));
        this.bounds = new Bounds(itemOsmlintLinestring.getRectangle2D());
        this.bounds_default = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        if (this.bounds.getArea() < this.bounds_default.getArea()) {
            this.bounds = this.bounds_default;
        }
        this.checkTofixLayer();
        TofixDraw.draw_line(this.tofixLayer, this.node.getCoor(), list);
        Download.download(this.bounds, itemOsmlintLinestring.getWay());
        return accessToTask;
    }

    private AccessToTask work_osmlintmultipoint(ItemOsmlintMultipoint itemOsmlintMultipoint, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintMultipoint.getKey());
        List<Node> list = itemOsmlintMultipoint.get_nodes();
        this.node = new Node(new LatLon(list.get(0).getCoor().lat(), list.get(0).getCoor().lon()));
        this.bounds = new Bounds(itemOsmlintMultipoint.getRectangle2D());
        this.bounds_default = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        if (this.bounds.getArea() < this.bounds_default.getArea()) {
            this.bounds = this.bounds_default;
        }
        this.checkTofixLayer();
        TofixDraw.draw_nodes(this.tofixLayer, this.node.getCoor(), list);
        Download.download(this.bounds, itemOsmlintMultipoint.getWay());
        return accessToTask;
    }

    private AccessToTask work_osmlintmultilinestring(ItemOsmlintMultilinestring itemOsmlintMultilinestring, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintMultilinestring.getKey());
        List<List<List<Node>>> list = itemOsmlintMultilinestring.get_nodes();
        this.node = new Node(new LatLon(list.get(0).get(0).get(0).getCoor().lat(), list.get(0).get(0).get(0).getCoor().lon()));
        this.bounds = new Bounds(itemOsmlintMultilinestring.getRectangle2D());
        this.bounds_default = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        if (this.bounds.getArea() < this.bounds_default.getArea()) {
            this.bounds = this.bounds_default;
        }
        this.checkTofixLayer();
        TofixDraw.draw_lines(this.tofixLayer, this.node.getCoor(), list);
        Download.download(this.bounds, itemOsmlintMultilinestring.getWay());
        return accessToTask;
    }

    private AccessToTask work_osmlintpolygon(ItemOsmlintPolygon itemOsmlintPolygon, AccessToTask accessToTask, double size, JsonArray relation) {
        accessToTask.setKey(itemOsmlintPolygon.getKey());
        List<List<List<Node>>> list = itemOsmlintPolygon.get_nodes();
        this.node = new Node(new LatLon(list.get(0).get(0).get(0).getCoor().lat(), list.get(0).get(0).get(0).getCoor().lon()));
        if (relation != null && relation.size() > 0) {
            for (int i = 0; i < relation.size(); ++i) {
                List<List<List<List<Node>>>> list_rel;
                String type = ((JsonValue)relation.getJsonObject(i).getJsonObject("geometry").get((Object)"type")).toString();
                JsonObject jo = relation.getJsonObject(i);
                Node node_rel = new Node();
                if (type.contains("Point")) {
                    ItemOsmlintPoint point = new ItemOsmlintPoint();
                    point.setGeometry(type);
                    point.setCoordinates(((JsonValue)jo.getJsonObject("geometry").get((Object)"coordinates")).toString());
                    node_rel = point.get_node();
                    this.tofixLayer.add_Node(node_rel.getCoor());
                }
                if (type.contains("LineString")) {
                    ItemOsmlintLinestring linestring = new ItemOsmlintLinestring();
                    linestring.setGeometry(type);
                    linestring.setCoordinates(((JsonValue)jo.getJsonObject("geometry").get((Object)"coordinates")).toString());
                    list_rel = linestring.get_nodes();
                    node_rel = new Node(new LatLon(list_rel.get(0).get(0).getCoor().lat(), ((Node)list_rel.get(0).get(0)).getCoor().lon()));
                    this.tofixLayer.add_Line(list_rel);
                }
                if (type.contains("MultiPoint")) {
                    ItemOsmlintMultipoint multipoint = new ItemOsmlintMultipoint();
                    multipoint.setGeometry(type);
                    multipoint.setCoordinates(((JsonValue)jo.getJsonObject("geometry").get((Object)"coordinates")).toString());
                    list_rel = multipoint.get_nodes();
                    node_rel = new Node(new LatLon(((Node)list_rel.get(0)).getCoor().lat(), ((Node)list_rel.get(0)).getCoor().lon()));
                    this.tofixLayer.add_Nodes(list_rel);
                }
                if (type.contains("MultiLineString")) {
                    ItemOsmlintMultilinestring multilinestring = new ItemOsmlintMultilinestring();
                    multilinestring.setGeometry(type);
                    multilinestring.setCoordinates(((JsonValue)jo.getJsonObject("geometry").get((Object)"coordinates")).toString());
                    list_rel = multilinestring.get_nodes();
                    node_rel = new Node(new LatLon(((Node)((List)list_rel.get(0).get(0)).get(0)).getCoor().lat(), ((Node)((List)list_rel.get(0).get(0)).get(0)).getCoor().lon()));
                    this.tofixLayer.add_lines(list_rel);
                }
                if (type.contains("Polygon")) {
                    ItemOsmlintPolygon polygon = new ItemOsmlintPolygon();
                    polygon.setGeometry(type);
                    polygon.setCoordinates(((JsonValue)jo.getJsonObject("geometry").get((Object)"coordinates")).toString());
                    list_rel = polygon.get_nodes();
                    node_rel = new Node(new LatLon(((Node)((List)list_rel.get(0).get(0)).get(0)).getCoor().lat(), ((Node)((List)list_rel.get(0).get(0)).get(0)).getCoor().lon()));
                    this.tofixLayer.add_lines(list_rel);
                }
                if (!type.contains("MultiPolygon")) continue;
                ItemOsmlintMultipolygon multipolygon = new ItemOsmlintMultipolygon();
                multipolygon.setGeometry(type);
                multipolygon.setCoordinates(((JsonValue)jo.getJsonObject("geometry").get((Object)"coordinates")).toString());
                list_rel = multipolygon.get_nodes();
                node_rel = new Node(new LatLon(((Node)((List)((List)list_rel.get(0).get(0)).get(0)).get(0)).getCoor().lat(), ((Node)((List)((List)list_rel.get(0).get(0)).get(0)).get(0)).getCoor().lon()));
                this.tofixLayer.add_Lines(list_rel);
            }
        }
        this.bounds = new Bounds(itemOsmlintPolygon.getRectangle2D());
        this.bounds_default = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        if (this.bounds.getArea() < this.bounds_default.getArea()) {
            this.bounds = this.bounds_default;
        }
        this.checkTofixLayer();
        TofixDraw.draw_lines(this.tofixLayer, this.node.getCoor(), list);
        Download.download(this.bounds, itemOsmlintPolygon.getWay());
        return accessToTask;
    }

    private AccessToTask work_osmlintmultipolygon(ItemOsmlintMultipolygon itemOsmlintMultipolygon, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintMultipolygon.getKey());
        List<List<List<List<Node>>>> list = itemOsmlintMultipolygon.get_nodes();
        this.node = new Node(new LatLon(list.get(0).get(0).get(0).get(0).getCoor().lat(), list.get(0).get(0).get(0).get(0).getCoor().lon()));
        this.bounds = new Bounds(itemOsmlintMultipolygon.getRectangle2D());
        this.bounds_default = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        if (this.bounds.getArea() < this.bounds_default.getArea()) {
            this.bounds = this.bounds_default;
        }
        this.checkTofixLayer();
        TofixDraw.draw_Lines(this.tofixLayer, this.node.getCoor(), list);
        Download.download(this.bounds, itemOsmlintMultipolygon.getWay());
        return accessToTask;
    }

    public void task_complete(Item item, AccessToTask accessToTask) {
        DecimalFormat myFormatter = new DecimalFormat("#,###");
        String num = myFormatter.format(item.getTaskCompleteBean().getTotal());
        String message = "Task " + accessToTask.getTask_name() + " is complete\n" + num + " issues fixed";
        new Notification(I18n.tr((String)message, (Object[])new Object[0])).show();
    }

    public final void checkTofixLayer() {
        if (!MainApplication.getLayerManager().containsLayer((Layer)this.tofixLayer)) {
            MainApplication.getLayerManager().addLayer((Layer)this.tofixLayer);
        }
    }
}

