/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.layers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.actions.OpenLinkAction;
import org.openstreetmap.josm.plugins.opendata.core.actions.ViewLicenseAction;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.OsmDownloader;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdDiffLayer;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdLayer;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdOsmDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OdDataLayer
extends OsmDataLayer
implements OdLayer,
LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    public OdDiffLayer diffLayer;
    public OdOsmDataLayer osmLayer;
    public final AbstractDataSetHandler handler;
    private Bounds bounds;

    public OdDataLayer(DataSet data, String name, File associatedFile, AbstractDataSetHandler handler) {
        super(data, name, associatedFile);
        this.setUploadDiscouraged(true);
        this.handler = handler;
        for (Node node : data.getNodes()) {
            LatLon ll = node.getCoor();
            if (ll == null) continue;
            if (this.bounds == null) {
                this.bounds = new Bounds(ll);
                continue;
            }
            this.bounds.extend(ll);
        }
        MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
    }

    public ImageProvider getBaseIconProvider() {
        return OdUtils.getImageProvider(this.handler != null ? this.handler.getDataLayerIconName() : "o16.png");
    }

    public void addOsmLayer(OdOsmDataLayer layer) {
        this.removeOsmLayer();
        this.osmLayer = layer;
        MainApplication.getLayerManager().addLayer((Layer)this.osmLayer);
    }

    public void removeOsmLayer() {
        if (this.osmLayer != null) {
            MainApplication.getLayerManager().removeLayer((Layer)this.osmLayer);
            this.osmLayer = null;
        }
    }

    public void addDiffLayer(OdDiffLayer layer) {
        this.removeDiffLayer();
        this.diffLayer = layer;
        MainApplication.getLayerManager().addLayer((Layer)this.diffLayer);
    }

    public void removeDiffLayer() {
        if (this.diffLayer != null) {
            MainApplication.getLayerManager().removeLayer((Layer)this.diffLayer);
            this.diffLayer = null;
        }
    }

    public final void downloadOsmData() {
        if (this.handler != null) {
            String oapiReq = this.handler.getOverpassApiRequest(this.bounds);
            Collection<String> xapiReqs = this.handler.getOsmXapiRequests(this.bounds);
            if (oapiReq != null || xapiReqs != null) {
                DataSet dataSet = new DataSet();
                OdOsmDataLayer layer = new OdOsmDataLayer(this, dataSet, this.getName() + "/OSM");
                this.addOsmLayer(layer);
                MainApplication.getLayerManager().setActiveLayer((Layer)this.osmLayer);
                if (oapiReq != null) {
                    OsmDownloader.downloadOapi(oapiReq);
                    layer.removeForbiddenTags();
                } else {
                    OsmDownloader.downloadXapi(xapiReqs);
                }
            }
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (MainApplication.getLayerManager().getActiveLayer() == this && this.handler != null) {
            this.handler.notifyActive();
        }
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() == this) {
            this.removeOsmLayer();
            this.removeDiffLayer();
        } else if (e.getRemovedLayer() == this.osmLayer) {
            this.osmLayer = null;
        } else if (e.getRemovedLayer() == this.diffLayer) {
            this.diffLayer = null;
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public Action[] getMenuEntries() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Action entry : super.getMenuEntries()) {
            result.add(entry);
        }
        if (this.handler != null) {
            if (this.handler.getWikiURL() != null || this.handler.getLocalPortalURL() != null || this.handler.getNationalPortalURL() != null) {
                result.add(Layer.SeparatorLayerAction.INSTANCE);
            }
            if (this.handler.getWikiURL() != null) {
                result.add((Object)new OpenLinkAction(this.handler.getWikiURL(), "osm24.png", I18n.tr((String)"View OSM Wiki page", (Object[])new Object[0]), I18n.tr((String)"Launch browser to the OSM Wiki page of the selected data set", (Object[])new Object[0])));
            }
            if (this.handler.getLocalPortalURL() != null) {
                result.add((Object)new OpenLinkAction(this.handler.getLocalPortalURL(), this.handler.getLocalPortalIconName(), I18n.tr((String)"View Local Portal page", (Object[])new Object[0]), I18n.tr((String)"Launch browser to the local portal page of the selected data set", (Object[])new Object[0])));
            }
            if (this.handler.getNationalPortalURL() != null) {
                result.add((Object)new OpenLinkAction(this.handler.getNationalPortalURL(), this.handler.getNationalPortalIconName(), I18n.tr((String)"View National Portal page", (Object[])new Object[0]), I18n.tr((String)"Launch browser to the national portal page of the selected data set", (Object[])new Object[0])));
            }
            if (this.handler.getLicense() != null) {
                License lic = this.handler.getLicense();
                if (lic.getURL() != null && lic.getURL().getProtocol().startsWith("http")) {
                    result.add((Object)new OpenLinkAction(lic.getURL(), "agreement24.png", I18n.tr((String)"View License", (Object[])new Object[0]), I18n.tr((String)"Launch browser to the license page of the selected data set", (Object[])new Object[0])));
                }
                if (lic.getSummaryURL() != null && lic.getSummaryURL().getProtocol().startsWith("http")) {
                    result.add((Object)new OpenLinkAction(lic.getSummaryURL(), "agreement24.png", I18n.tr((String)"View License (summary)", (Object[])new Object[0]), I18n.tr((String)"Launch browser to the summary license page of the selected data set", (Object[])new Object[0])));
                }
                if (lic.getURL() != null && !lic.getURL().getProtocol().startsWith("http") || lic.getSummaryURL() != null && !lic.getSummaryURL().getProtocol().startsWith("http")) {
                    result.add((Object)new ViewLicenseAction(lic, I18n.tr((String)"View License", (Object[])new Object[0]), I18n.tr((String)"View the license of the selected data set", (Object[])new Object[0])));
                }
            }
        }
        return result.toArray(new Action[0]);
    }

    @Override
    public OdDataLayer getDataLayer() {
        return this;
    }

    public void makeDiff() {
        OdDiffLayer layer = new OdDiffLayer(this, this.getName() + "/Diff");
        this.addDiffLayer(layer);
        MainApplication.getLayerManager().setActiveLayer((Layer)this.diffLayer);
    }
}

