/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Vector;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormat;

public final class HSSFDataFormat
implements DataFormat {
    private static final String[] _builtinFormats = BuiltinFormats.getAll();
    private final Vector<String> _formats = new Vector();
    private boolean _movedBuiltins = false;

    HSSFDataFormat(InternalWorkbook internalWorkbook) {
        for (FormatRecord formatRecord : internalWorkbook.getFormats()) {
            if (this._formats.size() < formatRecord.getIndexCode() + 1) {
                this._formats.setSize(formatRecord.getIndexCode() + 1);
            }
            this._formats.set(formatRecord.getIndexCode(), formatRecord.getFormatString());
        }
    }

    @Override
    public String getFormat(short s) {
        if (this._movedBuiltins) {
            return this._formats.get(s);
        }
        if (_builtinFormats.length > s && _builtinFormats[s] != null) {
            return _builtinFormats[s];
        }
        return this._formats.get(s);
    }
}

