/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.gui;

import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.rmi.server.UID;
import java.util.Hashtable;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.rasterfilters.model.FiltersManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class FilterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private UID filterId;
    private int neededHeight;

    public FilterPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(Color.white);
    }

    public JComponent addGuiElement(JsonObject json) {
        String type = json.getString("type");
        if (type.equals("linear_slider")) {
            this.setNeededHeight(this.getNeededHeight() + 70);
            return this.createSlider(json);
        }
        if (type.equals("checkbox")) {
            this.setNeededHeight(this.getNeededHeight() + 30);
            JCheckBox checkBox = this.createCheckBox(json.getString("title"));
            checkBox.setSelected(json.getBoolean("default"));
            checkBox.setName(json.getString("name"));
            return checkBox;
        }
        if (type.equals("select")) {
            this.setNeededHeight(this.getNeededHeight() + 50);
            return this.createSelect(json);
        }
        if (type.equals("colorpicker")) {
            this.setNeededHeight(this.getNeededHeight() + 220);
            return this.createColorPicker(json);
        }
        return null;
    }

    private JComponent createSelect(JsonObject json) {
        Font font = new Font("Arial", 0, 14);
        JPanel selectPanel = new JPanel();
        selectPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        selectPanel.setBackground(Color.white);
        selectPanel.setLayout(new BoxLayout(selectPanel, 0));
        selectPanel.setMaximumSize(new Dimension(300, 40));
        JLabel selectTitle = new JLabel(json.getString("title"));
        selectTitle.setFont(font);
        selectTitle.setBackground(Color.white);
        JsonArray valuesArray = json.getJsonArray("values");
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.setSelectedItem(json.getString("default"));
        for (int i = 0; i < valuesArray.size(); ++i) {
            model.addElement(valuesArray.getString(i));
        }
        JComboBox selectBox = new JComboBox(model);
        selectBox.setMinimumSize(new Dimension(140, 30));
        selectPanel.add(selectTitle);
        selectPanel.add(Box.createHorizontalGlue());
        selectPanel.add(selectBox);
        selectBox.setName(json.getString("name"));
        this.add(selectPanel);
        return selectBox;
    }

    public JComponent createColorPicker(JsonObject json) {
        ColorPicker picker = new ColorPicker(false, false);
        picker.setPreferredSize(new Dimension(200, 180));
        picker.setMode(0);
        picker.setName(json.getString("name"));
        this.addControlTitle(json.getString("title"));
        this.add(picker);
        return picker;
    }

    public JCheckBox createCheckBox(String text) {
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setMaximumSize(new Dimension(300, 30));
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
        checkBoxPanel.setBackground(Color.white);
        JCheckBox checkBox = new JCheckBox(text);
        Font font = new Font("Arial", 0, 12);
        checkBox.setFont(font);
        checkBox.setBackground(Color.white);
        checkBox.setName(text);
        checkBoxPanel.add(checkBox);
        this.add(checkBoxPanel);
        return checkBox;
    }

    private JCheckBox createDisableBox(ItemListener listener) {
        JCheckBox disable = new JCheckBox("Disable");
        Font font = new Font("Arial", 0, 12);
        disable.addItemListener(listener);
        disable.setFont(font);
        return disable;
    }

    private JButton createRemoveButton(ActionListener listener) {
        JButton removeButton = new JButton("Remove");
        Font font = new Font("Arial", 0, 12);
        removeButton.setFont(font);
        removeButton.setName("remove");
        removeButton.addActionListener(listener);
        return removeButton;
    }

    public JPanel createBottomPanel(FiltersManager listener) {
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.setMaximumSize(new Dimension(300, 40));
        bottom.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.gray));
        bottom.add(this.createDisableBox(listener));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.createRemoveButton(listener));
        this.add(bottom);
        return bottom;
    }

    private void addControlTitle(String labelText) {
        Font labelFont = new Font("Arial", 0, 14);
        JPanel sliderLabelPanel = new JPanel();
        sliderLabelPanel.setMaximumSize(new Dimension(400, 30));
        sliderLabelPanel.setLayout(new FlowLayout(0));
        sliderLabelPanel.setBackground(Color.white);
        JLabel sliderLabel = new JLabel(labelText, 2);
        sliderLabel.setFont(labelFont);
        sliderLabel.setAlignmentX(0.0f);
        sliderLabel.setVisible(true);
        sliderLabelPanel.add(sliderLabel);
        this.add(sliderLabelPanel);
    }

    public JSlider createSlider(JsonObject json) {
        EmptyBorder sliderBorder = new EmptyBorder(5, 5, 5, 5);
        this.addControlTitle(json.getString("title"));
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JsonArray array = json.getJsonArray("scale");
        String valueType = json.getString("value_type");
        JComponent slider = null;
        if (valueType.equals("integer")) {
            int minValue = array.getInt(0);
            int maxValue = array.getInt(1);
            int initValue = json.getInt("default");
            Logging.debug((String)"Slider is integer\n");
            Logging.debug((String)("minValue: " + String.valueOf(minValue) + "maxValue: " + String.valueOf(maxValue)));
            try {
                slider = new JSlider(0, minValue, maxValue, initValue);
                slider.setName(json.getString("name"));
                slider.setToolTipText(String.valueOf(((JSlider)slider).getValue()));
                ((JSlider)slider).setMinorTickSpacing(maxValue / 4);
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"JSlider initialization error. Make sure your meta-inf is correct.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        } else if (valueType.equals("float")) {
            Logging.debug((String)"Slider is float\n");
            double minValueDouble = array.getJsonNumber(0).doubleValue();
            double maxValueDouble = array.getJsonNumber(1).doubleValue();
            Logging.debug((String)("DminValue: " + String.valueOf(minValueDouble) + "DmaxValue: " + String.valueOf(maxValueDouble)));
            int minValue = (int)(minValueDouble * 100.0);
            int maxValue = (int)(maxValueDouble * 100.0);
            double initValue = json.getJsonNumber("default").doubleValue() * 100.0;
            double delta = (maxValue - minValue) / 100;
            for (int i = 0; i <= maxValue; ++i) {
                if (i % 20 != 0) continue;
                labelTable.put(i, new JLabel(String.valueOf((double)i * delta / 100.0)));
            }
            try {
                slider = new JSlider(0, minValue, maxValue, (int)initValue);
                ((JSlider)slider).setMinorTickSpacing(maxValue / 4);
                slider.setName(json.getString("name"));
                slider.setToolTipText(String.valueOf((double)((JSlider)slider).getValue() / 100.0));
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"JSlider initialization error. Make sure your meta-inf is correct.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        }
        slider.setBackground(this.getBackground());
        slider.setBorder(sliderBorder);
        ((JSlider)slider).setPaintTicks(true);
        ((JSlider)slider).setPaintLabels(true);
        this.add(slider);
        return slider;
    }

    public void setFilterId(UID filterId) {
        this.filterId = filterId;
    }

    public UID getFilterId() {
        return this.filterId;
    }

    public int getNeededHeight() {
        return this.neededHeight;
    }

    public void setNeededHeight(int neededHeight) {
        this.neededHeight = neededHeight;
    }
}

