/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.rasterfilters.gui.FiltersDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public final class ShowFiltersDialogAction
extends AbstractAction
implements Layer.LayerAction {
    private List<FiltersDialog> dialogs = new ArrayList<FiltersDialog>();

    public ShowFiltersDialogAction() {
        this.putValue("Name", I18n.tr((String)"Filters", (Object[])new Object[0]));
        this.putValue("ShortDescription", I18n.tr((String)"Choose Filter", (Object[])new Object[0]));
        this.putValue("ImageResource", new ImageProvider("josm_filters_48.png").getResource());
    }

    public void addFiltersDialog(FiltersDialog dialog) {
        this.dialogs.add(dialog);
    }

    public void removeFiltersDialog(FiltersDialog dialog) {
        this.dialogs.remove(dialog);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Layer layer = MainApplication.getLayerManager().getActiveLayer();
        if (layer instanceof ImageryLayer) {
            for (FiltersDialog temp : this.dialogs) {
                if (!temp.getLayer().equals(layer)) continue;
                try {
                    temp.createAndShowGui();
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                break;
            }
        } else {
            Logging.debug((String)("The layer is not the instance of " + ImageryLayer.class.getCanonicalName()));
        }
    }

    public FiltersDialog getDialogByLayer(Layer layer) {
        for (FiltersDialog dialog : this.dialogs) {
            if (!dialog.getLayer().equals(layer)) continue;
            return dialog;
        }
        return null;
    }

    public boolean supportLayers(List<Layer> layers) {
        return true;
    }

    public Component createMenuComponent() {
        return new JMenuItem(this);
    }
}

