/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.swing.BlockingPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class AppletPopupFactory
extends PopupFactory {
    private static boolean initialized = false;
    PopupFactory oldFactory;

    public static void initialize() {
        if (initialized) {
            return;
        }
        try {
            PopupFactory oldFactory = PopupFactory.getSharedInstance();
            PopupFactory.setSharedInstance(new AppletPopupFactory(oldFactory));
        }
        finally {
            initialized = true;
        }
    }

    public static Component[] getHierarchy(Component c) {
        LinkedList<Component> hierarchy = new LinkedList<Component>();
        while (c != null) {
            hierarchy.add(c);
            c = c.getParent();
        }
        return hierarchy.toArray(new Component[hierarchy.size()]);
    }

    AppletPopupFactory(PopupFactory oldFactory) {
        this.oldFactory = oldFactory;
    }

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        Component[] hierarchy = AppletPopupFactory.getHierarchy(owner);
        int a = hierarchy.length - 1;
        while (a >= 0) {
            if (hierarchy[a] instanceof JApplet && contents instanceof JComponent) {
                return new AppletPopup((JApplet)hierarchy[a], owner, (JComponent)contents, x, y);
            }
            if (hierarchy[a] instanceof JFrame) {
                return this.oldFactory.getPopup(owner, contents, x, y);
            }
            --a;
        }
        return this.oldFactory.getPopup(owner, contents, x, y);
    }

    static class AppletPopup
    extends Popup {
        AbstractAction hideAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AppletPopup.this.hide();
            }
        };
        final JApplet applet;
        final JComponent component;
        final Component owner;
        final int x;
        final int y;
        BlockingPane background;
        Color borderColor = Color.gray;
        Color backgroundColor = null;
        boolean transferredContents = false;

        public AppletPopup(JApplet applet, Component owner, JComponent component, int x, int y) {
            if (applet == null) {
                throw new NullPointerException();
            }
            this.applet = applet;
            this.component = component;
            this.x = x;
            this.y = y;
            this.owner = owner;
            if (component.getBorder() instanceof LineBorder) {
                this.borderColor = ((LineBorder)component.getBorder()).getLineColor();
                component.setBorder(null);
            }
            Component[] t = component.getComponents();
            Component j = null;
            int a = 0;
            while (a < t.length && j == null) {
                if (!(t[a] instanceof Box.Filler)) {
                    j = t[a];
                }
                if (j instanceof JScrollPane) {
                    j = ((JScrollPane)j).getViewport().getComponent(0);
                }
                ++a;
            }
            if (j != null) {
                this.backgroundColor = j.getBackground();
            }
        }

        @Override
        public void hide() {
            Container parent = this.component.getParent();
            if (parent != null) {
                parent.remove(this.component);
            }
            this.background.setVisible(false);
        }

        @Override
        public void show() {
            if (this.component == null) {
                return;
            }
            Dimension size = this.component.getPreferredSize();
            if (this.owner instanceof JComponent) {
                JComponent jc = (JComponent)this.owner;
                InputMap inputMap = jc.getInputMap(2);
                inputMap.put(KeyStroke.getKeyStroke(27, 0), "hidePopup");
                jc.getActionMap().put("hidePopup", this.hideAction);
            }
            if (this.component.getParent() != this.applet.getLayeredPane()) {
                this.applet.getLayeredPane().add((Component)this.component, JLayeredPane.POPUP_LAYER);
            }
            this.background = new MyBlockingPane();
            this.background.install(this.applet);
            Point convertedPoint = new Point(this.x, this.y);
            SwingUtilities.convertPointFromScreen(convertedPoint, this.applet);
            int myX = convertedPoint.x;
            int myY = convertedPoint.y;
            if (myY < 0) {
                myY = 0;
            }
            if (myY + size.height > this.applet.getHeight() - 1) {
                myY = Math.max(0, this.applet.getHeight() - size.height - 1);
            }
            if (myX < 0) {
                myX = 0;
            }
            if (myX + size.width > this.applet.getWidth() - 1) {
                myX = Math.max(0, this.applet.getWidth() - size.width - 1);
            }
            this.component.setBounds(myX, myY, size.width, size.height);
            this.component.validate();
        }

        class MyBlockingPane
        extends BlockingPane {
            private static final long serialVersionUID = 1L;

            MyBlockingPane() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AppletPopup.this.hide();
                super.mouseClicked(e);
            }

            @Override
            protected void paintComponent(Graphics g0) {
                super.paintComponent(g0);
                Graphics2D g = (Graphics2D)g0;
                Rectangle rect = AppletPopup.this.component.getBounds();
                if (AppletPopup.this.backgroundColor != null) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    g2.setColor(new Color(0, 0, 0, 4));
                    int a = 0;
                    while (a < 10) {
                        g2.setStroke(new BasicStroke(a + 1, 1, 1));
                        g2.drawRect(rect.x, rect.y + a / 2, rect.width, rect.height);
                        ++a;
                    }
                    g2.dispose();
                    g.setColor(AppletPopup.this.backgroundColor);
                    g.fillRect(rect.x - 1, rect.y - 1, rect.width + 1, rect.height + 1);
                }
                if (AppletPopup.this.borderColor != null) {
                    g.setColor(AppletPopup.this.borderColor);
                    g.drawRect(rect.x - 1, rect.y - 1, rect.width + 1, rect.height + 1);
                }
            }
        }
    }
}

