/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;
import terracer.HouseNumberInputHandler;
import terracer.TerracerRuntimeException;

public final class TerracerAction
extends JosmAction {
    Collection<Command> commands;
    private Collection<OsmPrimitive> primitives;
    private TagCollection tagsInConflict;

    public TerracerAction() {
        super(I18n.tr((String)"Terrace a building", (Object[])new Object[0]), "terrace", I18n.tr((String)"Creates individual buildings from a long building.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:Terracer", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Terrace a building", (Object[])new Object[0])}), (int)84, (int)5005), true);
    }

    protected static Set<Relation> findAssociatedStreets(Collection<OsmPrimitive> objects) {
        HashSet<Relation> result = new HashSet<Relation>();
        if (objects != null) {
            for (OsmPrimitive c : objects) {
                if (c == null) continue;
                for (OsmPrimitive p : c.getReferrers()) {
                    if (!(p instanceof Relation) || !"associatedStreet".equals(p.get("type"))) continue;
                    result.add((Relation)p);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Set<Relation> associatedStreets;
        Collection sel = this.getLayerManager().getEditDataSet().getSelected();
        Way outline = null;
        Way street = null;
        String streetname = null;
        ArrayList<Node> housenumbers = new ArrayList<Node>();
        Node init = null;
        try {
            if (sel.size() == 1) {
                OsmPrimitive prim = (OsmPrimitive)sel.iterator().next();
                if (!(prim instanceof Way)) {
                    throw new InvalidUserInputException(prim + " is not a way");
                }
                outline = (Way)prim;
            } else if (sel.size() > 1) {
                List ways = OsmPrimitive.getFilteredList((Collection)sel, Way.class);
                for (Way way : ways) {
                    if (way.hasKey("building")) {
                        if (outline != null) {
                            throw new InvalidUserInputException("already have a building");
                        }
                        outline = way;
                        continue;
                    }
                    if (way.hasKey("highway")) {
                        if (street != null) {
                            throw new InvalidUserInputException("already have a street");
                        }
                        street = way;
                        streetname = street.get("name");
                        if (streetname != null) continue;
                        throw new InvalidUserInputException("street does not have any name");
                    }
                    throw new InvalidUserInputException(way + " is neither a building nor a highway");
                }
                if (outline == null) {
                    throw new InvalidUserInputException("no outline way found");
                }
                List nodes = OsmPrimitive.getFilteredList((Collection)sel, Node.class);
                for (Node node : nodes) {
                    if (node.hasKey("addr:housenumber")) {
                        String nodesStreetName = node.get("addr:street");
                        if (nodesStreetName != null) {
                            if (streetname == null) {
                                streetname = nodesStreetName;
                            } else if (!nodesStreetName.equals(streetname)) {
                                throw new InvalidUserInputException("addr:street does not match street name");
                            }
                        }
                        housenumbers.add(node);
                        continue;
                    }
                    if (!outline.containsNode(node) || init != null) {
                        throw new InvalidUserInputException("node problem");
                    }
                    init = node;
                }
                Collections.sort(housenumbers, new HousenumberNodeComparator());
            }
            if (outline == null || !outline.isClosed() || outline.getNodesCount() < 5) {
                throw new InvalidUserInputException("wrong or missing outline");
            }
        }
        catch (InvalidUserInputException ex) {
            Logging.warn((String)("Terracer: " + ex.getMessage()));
            new ExtendedDialog(Main.parent, I18n.tr((String)"Invalid selection", (Object[])new Object[0]), new String[]{"OK"}).setButtonIcons(new String[]{"ok"}).setIcon(1).setContent(I18n.tr((String)"Select a single, closed way of at least four nodes. (Optionally you can also select a street for the addr:street tag and a node to mark the start of numbering.)", (Object[])new Object[0])).showDialog();
            return;
        }
        Relation associatedStreet = null;
        HashSet<OsmPrimitive> candidates = new HashSet<OsmPrimitive>(housenumbers);
        candidates.add((OsmPrimitive)outline);
        if (street != null) {
            candidates.add((OsmPrimitive)street);
        }
        if (!(associatedStreets = TerracerAction.findAssociatedStreets(candidates)).isEmpty()) {
            associatedStreet = associatedStreets.iterator().next();
            if (associatedStreets.size() > 1) {
                Logging.warn((String)("Terracer: Found " + associatedStreets.size() + " associatedStreet relations. Considering the first one only."));
            }
        }
        if (streetname == null && associatedStreet != null && associatedStreet.hasKey("name")) {
            streetname = associatedStreet.get("name");
        }
        if (housenumbers.size() == 1) {
            try {
                this.terraceBuilding(outline, init, street, associatedStreet, 0, null, null, 0, housenumbers, streetname, associatedStreet != null, false, "yes");
            }
            catch (UserCancelException ex) {
                Logging.trace((Throwable)ex);
            }
            finally {
                this.commands.clear();
                this.commands = null;
            }
        } else {
            String title = I18n.trn((String)"Change {0} object", (String)"Change {0} objects", (long)sel.size(), (Object[])new Object[]{sel.size()});
            new HouseNumberInputHandler((TerracerAction)this, (Way)outline, (Node)init, (Way)street, (String)streetname, (String)outline.get((String)"building"), (Relation)associatedStreet, housenumbers, (String)title).dialog.showDialog();
        }
    }

    public Integer getNumber(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void terraceBuilding(Way outline, Node init, Way street, Relation associatedStreet, Integer segments, String start, String end, int step, List<Node> housenumbers, String streetName, boolean handleRelations, boolean keepOutline, String buildingValue) throws UserCancelException {
        int nb;
        Integer to = null;
        Integer from = null;
        if (housenumbers == null || housenumbers.isEmpty()) {
            to = this.getNumber(end);
            from = this.getNumber(start);
            if (to != null && from != null) {
                nb = 1 + (to - from) / step;
            } else {
                if (segments == null) throw new TerracerRuntimeException("Could not determine segments from parameters, this is a bug. Parameters were: segments " + segments + " from " + from + " to " + to + " step " + step);
                nb = segments;
            }
        } else {
            nb = housenumbers.size();
        }
        Pair<Way, Way> interp = this.findFrontAndBack(outline);
        boolean swap = init != null && (((Way)interp.a).lastNode().equals((Object)init) || ((Way)interp.b).lastNode().equals((Object)init));
        double frontLength = this.wayLength((Way)interp.a);
        double backLength = this.wayLength((Way)interp.b);
        Node[][] newNodes = new Node[2][nb + 1];
        ArrayList<Node> reusedNodes = new ArrayList<Node>();
        this.commands = new LinkedList<Command>();
        LinkedList<Way> ways = new LinkedList<Way>();
        if (nb > 1) {
            int i;
            for (i = 0; i <= nb; ++i) {
                int iDir = swap ? nb - i : i;
                newNodes[0][i] = this.interpolateAlong((Way)interp.a, frontLength * (double)iDir / (double)nb);
                newNodes[1][i] = this.interpolateAlong((Way)interp.b, backLength * (double)iDir / (double)nb);
                if (!outline.containsNode(newNodes[0][i])) {
                    this.commands.add((Command)new AddCommand((OsmPrimitive)newNodes[0][i]));
                } else {
                    reusedNodes.add(newNodes[0][i]);
                }
                if (!outline.containsNode(newNodes[1][i])) {
                    this.commands.add((Command)new AddCommand((OsmPrimitive)newNodes[1][i]));
                    continue;
                }
                reusedNodes.add(newNodes[1][i]);
            }
            for (i = 0; i < nb; ++i) {
                Way terr;
                boolean createNewWay;
                boolean bl = createNewWay = i > 0 || keepOutline;
                if (createNewWay) {
                    terr = new Way();
                    TagCollection.from((Tagged)outline).applyTo((Tagged)terr);
                } else {
                    terr = new Way(outline);
                    terr.setNodes(null);
                }
                terr.addNode(newNodes[0][i]);
                terr.addNode(newNodes[0][i + 1]);
                terr.addNode(newNodes[1][i + 1]);
                terr.addNode(newNodes[1][i]);
                terr.addNode(newNodes[0][i]);
                this.addressBuilding(terr, street, streetName, associatedStreet, housenumbers, i, from != null ? Integer.toString(from + i * step) : null, buildingValue);
                if (createNewWay) {
                    ways.add(terr);
                    this.commands.add((Command)new AddCommand((OsmPrimitive)terr));
                    continue;
                }
                ways.add(outline);
                this.commands.add((Command)new ChangeCommand((OsmPrimitive)outline, (OsmPrimitive)terr));
            }
            if (!keepOutline) {
                List nodes = outline.getNodes();
                ArrayList<Node> nodesToDelete = new ArrayList<Node>();
                for (Node n : nodes) {
                    if (n.hasKeys() || n.getReferrers().size() != 1 || reusedNodes.contains(n)) continue;
                    nodesToDelete.add(n);
                }
                if (!nodesToDelete.isEmpty()) {
                    this.commands.add(DeleteCommand.delete((OsmDataLayer)MainApplication.getLayerManager().getEditLayer(), nodesToDelete));
                }
            }
        } else {
            this.addressBuilding(outline, street, streetName, associatedStreet, housenumbers, 0, start, buildingValue);
            ways.add(outline);
        }
        if (!housenumbers.isEmpty()) {
            this.commands.add(DeleteCommand.delete((OsmDataLayer)MainApplication.getLayerManager().getEditLayer(), housenumbers, (boolean)true, (boolean)true));
        }
        if (handleRelations) {
            if (associatedStreet == null) {
                this.addNewAssociatedStreetRelation(street, streetName, ways);
            } else {
                this.updateAssociatedStreetRelation(associatedStreet, housenumbers, ways);
            }
        }
        MainApplication.undoRedo.add(this.createTerracingCommand(outline));
        if (nb <= 1 && street != null) {
            MainApplication.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{street});
            return;
        } else {
            MainApplication.getLayerManager().getEditDataSet().setSelected(ways);
        }
    }

    private void updateAssociatedStreetRelation(Relation associatedStreet, List<Node> housenumbers, Collection<Way> ways) {
        Relation newAssociatedStreet = new Relation(associatedStreet);
        newAssociatedStreet.removeMembersFor(housenumbers);
        for (Way w : ways) {
            newAssociatedStreet.addMember(new RelationMember("house", (OsmPrimitive)w));
        }
        this.commands.add((Command)new ChangeCommand((OsmPrimitive)associatedStreet, (OsmPrimitive)newAssociatedStreet));
    }

    private void addNewAssociatedStreetRelation(Way street, String streetName, Collection<Way> ways) {
        Relation associatedStreet = new Relation();
        associatedStreet.put("type", "associatedStreet");
        if (street != null) {
            associatedStreet.put("name", street.get("name"));
            associatedStreet.addMember(new RelationMember("street", (OsmPrimitive)street));
        } else {
            associatedStreet.put("name", streetName);
        }
        for (Way w : ways) {
            associatedStreet.addMember(new RelationMember("house", (OsmPrimitive)w));
        }
        this.commands.add((Command)new AddCommand((OsmPrimitive)associatedStreet));
    }

    private Command createTerracingCommand(final Way outline) {
        return new SequenceCommand(I18n.tr((String)"Terrace", (Object[])new Object[0]), this.commands){

            public boolean executeCommand() {
                boolean result = super.executeCommand();
                if (result && TerracerAction.this.tagsInConflict != null) {
                    try {
                        List conflictCommands = CombinePrimitiveResolverDialog.launchIfNecessary((TagCollection)TerracerAction.this.tagsInConflict, (Collection)TerracerAction.this.primitives, Collections.singleton(outline));
                        if (!conflictCommands.isEmpty()) {
                            ArrayList<Command> newCommands = new ArrayList<Command>(TerracerAction.this.commands);
                            newCommands.addAll(conflictCommands);
                            this.setSequence(newCommands.toArray(new Command[0]));
                            for (int i = 0; i < conflictCommands.size(); ++i) {
                                result = ((Command)conflictCommands.get(i)).executeCommand();
                                if (result || this.continueOnError) continue;
                                this.setSequenceComplete(false);
                                this.undoCommands(TerracerAction.this.commands.size() + i - 1);
                                return false;
                            }
                        }
                    }
                    catch (UserCancelException e) {
                        Logging.trace((Throwable)e);
                    }
                }
                return result;
            }
        };
    }

    private void addressBuilding(Way outline, Way street, String streetName, Relation associatedStreet, List<Node> housenumbers, int i, String defaultNumber, String buildingValue) throws UserCancelException {
        Node houseNum = housenumbers != null && i >= 0 && i < housenumbers.size() ? housenumbers.get(i) : null;
        boolean buildingAdded = false;
        boolean numberAdded = false;
        if (houseNum != null) {
            this.primitives = Arrays.asList(houseNum, outline);
            TagCollection tagsToCopy = TagCollection.unionOfAllPrimitives(this.primitives).getTagsFor(houseNum.keySet());
            this.tagsInConflict = tagsToCopy.getTagsFor((Collection)tagsToCopy.getKeysWithMultipleValues());
            tagsToCopy = tagsToCopy.minus(this.tagsInConflict).minus(TagCollection.from((Tagged)outline));
            for (Tag tag : tagsToCopy) {
                this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)outline, tag.getKey(), tag.getValue()));
            }
            buildingAdded = houseNum.hasKey("building");
            numberAdded = houseNum.hasKey("addr:housenumber");
        }
        if (!buildingAdded && buildingValue != null && !buildingValue.isEmpty()) {
            this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)outline, "building", buildingValue));
        }
        if (defaultNumber != null && !numberAdded) {
            this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)outline, "addr:housenumber", defaultNumber));
        }
        if (associatedStreet == null || !associatedStreet.hasKey("name")) {
            if (street != null) {
                this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)outline, "addr:street", street.get("name")));
            } else if (streetName != null && !streetName.trim().isEmpty()) {
                this.commands.add((Command)new ChangePropertyCommand((OsmPrimitive)outline, "addr:street", streetName.trim()));
            }
        }
    }

    private Node interpolateAlong(Way w, double l) {
        List pairs = w.getNodePairs(false);
        for (int i = 0; i < pairs.size(); ++i) {
            Pair p = (Pair)pairs.get(i);
            double seg_length = ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
            if (l <= seg_length || i == pairs.size() - 1) {
                return this.interpolateNode((Node)p.a, (Node)p.b, l / seg_length);
            }
            l -= seg_length;
        }
        throw new IllegalStateException();
    }

    private double wayLength(Way w) {
        double length = 0.0;
        for (Pair p : w.getNodePairs(false)) {
            length += ((Node)p.a).getCoor().greatCircleDistance(((Node)p.b).getCoor());
        }
        return length;
    }

    private Pair<Way, Way> findFrontAndBack(Way w) {
        int i;
        int side2;
        double[] sideness = this.calculateSideness(w);
        int[] indexes = this.sortedIndexes(sideness);
        int side1 = indexes[0];
        if (this.indexDistance(side1, side2 = indexes[1], indexes.length) < 2) {
            side2 = indexes[2];
        }
        if (this.indexDistance(side1, side2, indexes.length) < 2) {
            side2 = indexes[3];
        }
        if (this.sideLength(w, side1) > this.sideLength(w, side1 + 1) && Math.abs(sideness[side1] - sideness[(side1 + 1) % (w.getNodesCount() - 1)]) < 0.001) {
            side1 = (side1 + 1) % (w.getNodesCount() - 1);
            side2 = (side2 + 1) % (w.getNodesCount() - 1);
        }
        if (side1 > side2) {
            int tmp = side2;
            side2 = side1;
            side1 = tmp;
        }
        Way front = new Way();
        Way back = new Way();
        for (i = side2 + 1; i < w.getNodesCount() - 1; ++i) {
            front.addNode(w.getNode(i));
        }
        for (i = 0; i <= side1; ++i) {
            front.addNode(w.getNode(i));
        }
        for (i = side2; i > side1; --i) {
            back.addNode(w.getNode(i));
        }
        return new Pair((Object)front, (Object)back);
    }

    private int indexDistance(int i1, int i2, int n) {
        return Math.min(this.positiveModulus(i1 - i2, n), this.positiveModulus(i2 - i1, n));
    }

    private int positiveModulus(int a, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int res = a % n;
        if (res < 0) {
            res += n;
        }
        return res;
    }

    private double sideLength(Way w, int i) {
        Node a = w.getNode(i);
        Node b = w.getNode((i + 1) % (w.getNodesCount() - 1));
        return a.getCoor().greatCircleDistance(b.getCoor());
    }

    private int[] sortedIndexes(double[] a) {
        int length = a.length;
        class SortWithIndex
        implements Comparable<SortWithIndex> {
            public double x;
            public int i;

            SortWithIndex(double a, int b) {
                this.x = a;
                this.i = b;
            }

            @Override
            public int compareTo(SortWithIndex o) {
                return Double.compare(this.x, o.x);
            }
        }
        ArrayList<SortWithIndex> sortable = new ArrayList<SortWithIndex>(length);
        for (int i = 0; i < length; ++i) {
            sortable.add(new SortWithIndex(a[i], i));
        }
        Collections.sort(sortable);
        int[] indexes = new int[length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = ((SortWithIndex)sortable.get((int)i)).i;
        }
        return indexes;
    }

    private double[] calculateSideness(Way w) {
        int length = w.getNodesCount() - 1;
        double[] sideness = new double[length];
        sideness[0] = this.calculateSideness(w.getNode(length - 1), w.getNode(0), w.getNode(1), w.getNode(2));
        for (int i = 1; i < length - 1; ++i) {
            sideness[i] = this.calculateSideness(w.getNode(i - 1), w.getNode(i), w.getNode(i + 1), w.getNode(i + 2));
        }
        sideness[length - 1] = this.calculateSideness(w.getNode(length - 2), w.getNode(length - 1), w.getNode(length), w.getNode(1));
        return sideness;
    }

    private double calculateSideness(Node a, Node b, Node c, Node d) {
        double ndx = b.getCoor().getX() - a.getCoor().getX();
        double pdx = d.getCoor().getX() - c.getCoor().getX();
        double ndy = b.getCoor().getY() - a.getCoor().getY();
        double pdy = d.getCoor().getY() - c.getCoor().getY();
        return (ndx * pdx + ndy * pdy) / Math.sqrt((ndx * ndx + ndy * ndy) * (pdx * pdx + pdy * pdy));
    }

    private Node interpolateNode(Node a, Node b, double f) {
        Node n = new Node(a.getEastNorth().interpolate(b.getEastNorth(), f));
        if (n.getCoor().equalsEpsilon(a.getCoor())) {
            return a;
        }
        if (n.getCoor().equalsEpsilon(b.getCoor())) {
            return b;
        }
        return n;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditDataSet() != null);
    }

    static class HousenumberNodeComparator
    implements Comparator<Node> {
        private final Pattern pat = Pattern.compile("^(\\d+)\\s*(.*)");

        HousenumberNodeComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            String node1String = node1.get("addr:housenumber");
            String node2String = node2.get("addr:housenumber");
            Matcher mat = this.pat.matcher(node1String);
            if (mat.find()) {
                Integer node1Int = Integer.valueOf(mat.group(1));
                String node1Rest = mat.group(2);
                mat = this.pat.matcher(node2String);
                if (mat.find()) {
                    Integer node2Int = Integer.valueOf(mat.group(1));
                    if (node1Int.equals(node2Int)) {
                        String node2Rest = mat.group(2);
                        return node1Rest.compareTo(node2Rest);
                    }
                    return node1Int.compareTo(node2Int);
                }
            }
            return node1String.compareTo(node2String);
        }
    }

    private static final class InvalidUserInputException
    extends Exception {
        InvalidUserInputException(String message) {
            super(message);
        }
    }
}

