/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType7;
import org.apache.pdfbox.pdmodel.graphics.shading.Type7ShadingContext;
import org.apache.pdfbox.util.Matrix;

public class Type7ShadingPaint
implements Paint {
    private static final Log LOG = LogFactory.getLog(Type7ShadingPaint.class);
    private final PDShadingType7 shading;
    private final Matrix ctm;
    private final int pageHeight;

    public Type7ShadingPaint(PDShadingType7 shading, Matrix ctm, int pageHeight) {
        this.shading = shading;
        this.ctm = ctm;
        this.pageHeight = pageHeight;
    }

    public int getTransparency() {
        return 0;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        try {
            return new Type7ShadingContext(this.shading, cm, xform, this.ctm, this.pageHeight, deviceBounds);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            return null;
        }
    }
}

