/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.util.CellRangeAddress8Bit;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public abstract class SharedValueRecordBase
extends StandardRecord {
    private CellRangeAddress8Bit _range;

    protected SharedValueRecordBase(CellRangeAddress8Bit cellRangeAddress8Bit) {
        if (cellRangeAddress8Bit == null) {
            throw new IllegalArgumentException("range must be supplied.");
        }
        this._range = cellRangeAddress8Bit;
    }

    protected SharedValueRecordBase() {
        this(new CellRangeAddress8Bit(0, 0, 0, 0));
    }

    public SharedValueRecordBase(LittleEndianInput littleEndianInput) {
        this._range = new CellRangeAddress8Bit(littleEndianInput);
    }

    public final CellRangeAddress8Bit getRange() {
        return this._range;
    }

    public final int getFirstRow() {
        return this._range.getFirstRow();
    }

    public final int getLastRow() {
        return this._range.getLastRow();
    }

    public final int getFirstColumn() {
        return (short)this._range.getFirstColumn();
    }

    public final int getLastColumn() {
        return (short)this._range.getLastColumn();
    }

    @Override
    protected int getDataSize() {
        return 6 + this.getExtraDataSize();
    }

    protected abstract int getExtraDataSize();

    protected abstract void serializeExtraData(LittleEndianOutput var1);

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        this._range.serialize(littleEndianOutput);
        this.serializeExtraData(littleEndianOutput);
    }

    public final boolean isInRange(int n, int n2) {
        CellRangeAddress8Bit cellRangeAddress8Bit = this._range;
        return cellRangeAddress8Bit.getFirstRow() <= n && cellRangeAddress8Bit.getLastRow() >= n && cellRangeAddress8Bit.getFirstColumn() <= n2 && cellRangeAddress8Bit.getLastColumn() >= n2;
    }

    public final boolean isFirstCell(int n, int n2) {
        CellRangeAddress8Bit cellRangeAddress8Bit = this.getRange();
        return cellRangeAddress8Bit.getFirstRow() == n && cellRangeAddress8Bit.getFirstColumn() == n2;
    }
}

