/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.ArrayRecord;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.TableRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.util.CellRangeAddress8Bit;
import org.apache.poi.hssf.util.CellReference;

public final class SharedValueManager {
    private final List<ArrayRecord> _arrayRecords;
    private final TableRecord[] _tableRecords;
    private final Map<SharedFormulaRecord, SharedFormulaGroup> _groupsBySharedFormulaRecord;
    private SharedFormulaGroup[] _groups;
    private static final Comparator<SharedFormulaGroup> SVGComparator = new Comparator<SharedFormulaGroup>(){

        @Override
        public int compare(SharedFormulaGroup sharedFormulaGroup, SharedFormulaGroup sharedFormulaGroup2) {
            CellRangeAddress8Bit cellRangeAddress8Bit = sharedFormulaGroup.getSFR().getRange();
            CellRangeAddress8Bit cellRangeAddress8Bit2 = sharedFormulaGroup2.getSFR().getRange();
            int n = cellRangeAddress8Bit.getFirstRow() - cellRangeAddress8Bit2.getFirstRow();
            if (n != 0) {
                return n;
            }
            n = cellRangeAddress8Bit.getFirstColumn() - cellRangeAddress8Bit2.getFirstColumn();
            if (n != 0) {
                return n;
            }
            return 0;
        }
    };

    public static SharedValueManager createEmpty() {
        return new SharedValueManager(new SharedFormulaRecord[0], new org.apache.poi.ss.util.CellReference[0], new ArrayRecord[0], new TableRecord[0]);
    }

    private SharedValueManager(SharedFormulaRecord[] sharedFormulaRecordArray, org.apache.poi.ss.util.CellReference[] cellReferenceArray, ArrayRecord[] arrayRecordArray, TableRecord[] tableRecordArray) {
        int n = sharedFormulaRecordArray.length;
        if (n != cellReferenceArray.length) {
            throw new IllegalArgumentException("array sizes don't match: " + n + "!=" + cellReferenceArray.length + ".");
        }
        this._arrayRecords = SharedValueManager.toList(arrayRecordArray);
        this._tableRecords = tableRecordArray;
        HashMap<SharedFormulaRecord, SharedFormulaGroup> hashMap = new HashMap<SharedFormulaRecord, SharedFormulaGroup>(n * 3 / 2);
        for (int i = 0; i < n; ++i) {
            SharedFormulaRecord sharedFormulaRecord = sharedFormulaRecordArray[i];
            hashMap.put(sharedFormulaRecord, new SharedFormulaGroup(sharedFormulaRecord, cellReferenceArray[i]));
        }
        this._groupsBySharedFormulaRecord = hashMap;
    }

    private static <Z> List<Z> toList(Z[] ZArray) {
        ArrayList<Z> arrayList = new ArrayList<Z>(ZArray.length);
        for (int i = 0; i < ZArray.length; ++i) {
            arrayList.add(ZArray[i]);
        }
        return arrayList;
    }

    public static SharedValueManager create(SharedFormulaRecord[] sharedFormulaRecordArray, org.apache.poi.ss.util.CellReference[] cellReferenceArray, ArrayRecord[] arrayRecordArray, TableRecord[] tableRecordArray) {
        if (sharedFormulaRecordArray.length + cellReferenceArray.length + arrayRecordArray.length + tableRecordArray.length < 1) {
            return SharedValueManager.createEmpty();
        }
        return new SharedValueManager(sharedFormulaRecordArray, cellReferenceArray, arrayRecordArray, tableRecordArray);
    }

    public SharedFormulaRecord linkSharedFormulaRecord(org.apache.poi.ss.util.CellReference cellReference, FormulaRecordAggregate formulaRecordAggregate) {
        SharedFormulaGroup sharedFormulaGroup = SharedValueManager.findFormulaGroup(this.getGroups(), cellReference);
        sharedFormulaGroup.add(formulaRecordAggregate);
        return sharedFormulaGroup.getSFR();
    }

    private static SharedFormulaGroup findFormulaGroup(SharedFormulaGroup[] sharedFormulaGroupArray, org.apache.poi.ss.util.CellReference cellReference) {
        int n = cellReference.getRow();
        short s = cellReference.getCol();
        for (int i = 0; i < sharedFormulaGroupArray.length; ++i) {
            SharedFormulaGroup sharedFormulaGroup = sharedFormulaGroupArray[i];
            if (!sharedFormulaGroup.isFirstCell(n, s)) continue;
            return sharedFormulaGroup;
        }
        throw new RuntimeException("Failed to find a matching shared formula record");
    }

    private SharedFormulaGroup[] getGroups() {
        if (this._groups == null) {
            SharedFormulaGroup[] sharedFormulaGroupArray = new SharedFormulaGroup[this._groupsBySharedFormulaRecord.size()];
            this._groupsBySharedFormulaRecord.values().toArray(sharedFormulaGroupArray);
            Arrays.sort(sharedFormulaGroupArray, SVGComparator);
            this._groups = sharedFormulaGroupArray;
        }
        return this._groups;
    }

    public SharedValueRecordBase getRecordForFirstCell(FormulaRecordAggregate formulaRecordAggregate) {
        CellReference cellReference = formulaRecordAggregate.getFormulaRecord().getFormula().getExpReference();
        if (cellReference == null) {
            return null;
        }
        int n = cellReference.getRow();
        short s = cellReference.getCol();
        if (formulaRecordAggregate.getRow() != n || formulaRecordAggregate.getColumn() != s) {
            return null;
        }
        SharedFormulaGroup[] sharedFormulaGroupArray = this.getGroups();
        for (int i = 0; i < sharedFormulaGroupArray.length; ++i) {
            SharedFormulaGroup sharedFormulaGroup = sharedFormulaGroupArray[i];
            if (!sharedFormulaGroup.isFirstCell(n, s)) continue;
            return sharedFormulaGroup.getSFR();
        }
        for (TableRecord tableRecord : this._tableRecords) {
            if (!tableRecord.isFirstCell(n, s)) continue;
            return tableRecord;
        }
        for (ArrayRecord arrayRecord : this._arrayRecords) {
            if (!arrayRecord.isFirstCell(n, s)) continue;
            return arrayRecord;
        }
        return null;
    }

    public void unlink(SharedFormulaRecord sharedFormulaRecord) {
        SharedFormulaGroup sharedFormulaGroup = this._groupsBySharedFormulaRecord.remove(sharedFormulaRecord);
        if (sharedFormulaGroup == null) {
            throw new IllegalStateException("Failed to find formulas for shared formula");
        }
        this._groups = null;
        sharedFormulaGroup.unlinkSharedFormulas();
    }

    public CellRangeAddress8Bit removeArrayFormula(int n, int n2) {
        for (ArrayRecord arrayRecord : this._arrayRecords) {
            if (!arrayRecord.isInRange(n, n2)) continue;
            this._arrayRecords.remove(arrayRecord);
            return arrayRecord.getRange();
        }
        String string = new org.apache.poi.ss.util.CellReference(n, n2, false, false).formatAsString();
        throw new IllegalArgumentException("Specified cell " + (String)string + " is not part of an array formula.");
    }

    public ArrayRecord getArrayRecord(int n, int n2) {
        for (ArrayRecord arrayRecord : this._arrayRecords) {
            if (!arrayRecord.isFirstCell(n, n2)) continue;
            return arrayRecord;
        }
        return null;
    }

    private static final class SharedFormulaGroup {
        private final SharedFormulaRecord _sfr;
        private final FormulaRecordAggregate[] _frAggs;
        private int _numberOfFormulas;
        private final org.apache.poi.ss.util.CellReference _firstCell;

        public SharedFormulaGroup(SharedFormulaRecord sharedFormulaRecord, org.apache.poi.ss.util.CellReference cellReference) {
            if (!sharedFormulaRecord.isInRange(cellReference.getRow(), cellReference.getCol())) {
                throw new IllegalArgumentException("First formula cell " + cellReference.formatAsString() + " is not shared formula range " + sharedFormulaRecord.getRange().toString() + ".");
            }
            this._sfr = sharedFormulaRecord;
            this._firstCell = cellReference;
            int n = sharedFormulaRecord.getLastColumn() - sharedFormulaRecord.getFirstColumn() + 1;
            int n2 = sharedFormulaRecord.getLastRow() - sharedFormulaRecord.getFirstRow() + 1;
            this._frAggs = new FormulaRecordAggregate[n * n2];
            this._numberOfFormulas = 0;
        }

        public void add(FormulaRecordAggregate formulaRecordAggregate) {
            if (this._numberOfFormulas == 0 && (this._firstCell.getRow() != formulaRecordAggregate.getRow() || this._firstCell.getCol() != formulaRecordAggregate.getColumn())) {
                throw new IllegalStateException("shared formula coding error");
            }
            if (this._numberOfFormulas >= this._frAggs.length) {
                throw new RuntimeException("Too many formula records for shared formula group");
            }
            this._frAggs[this._numberOfFormulas++] = formulaRecordAggregate;
        }

        public void unlinkSharedFormulas() {
            for (int i = 0; i < this._numberOfFormulas; ++i) {
                this._frAggs[i].unlinkSharedFormula();
            }
        }

        public SharedFormulaRecord getSFR() {
            return this._sfr;
        }

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this._sfr.getRange().toString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public boolean isFirstCell(int n, int n2) {
            return this._firstCell.getRow() == n && this._firstCell.getCol() == n2;
        }
    }
}

