/*
 * Decompiled with CFR 0.152.
 */
package iodb;

import iodb.IODBReader;
import iodb.ImageryOffsetBase;
import iodb.ImageryOffsetTools;
import iodb.ImageryOffsetWatcher;
import iodb.OffsetDialog;
import iodb.SimpleOffsetQueryTask;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class GetImageryOffsetAction
extends JosmAction
implements ImageryOffsetWatcher.OffsetStateListener {
    private Icon iconOffsetOk = new ImageProvider("getoffset").setSize(ImageProvider.ImageSizes.MENU).get();
    private Icon iconOffsetBad = new ImageProvider("getoffsetnow").setSize(ImageProvider.ImageSizes.MENU).get();

    public GetImageryOffsetAction() {
        super(I18n.tr((String)"Get Imagery Offset...", (Object[])new Object[0]), "getoffset", I18n.tr((String)"Download offsets for current imagery from a server", (Object[])new Object[0]), Shortcut.registerShortcut((String)"imageryoffset:get", (String)I18n.tr((String)"Imagery: {0}", (Object[])new Object[]{I18n.tr((String)"Get Imagery Offset...", (Object[])new Object[0])}), (int)73, (int)5008), true);
        ImageryOffsetWatcher.getInstance().register(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (!MainApplication.isDisplayingMapView() || !MainApplication.getMap().isVisible()) {
            return;
        }
        Projection proj = MainApplication.getMap().mapView.getProjection();
        LatLon center = proj.eastNorth2latlon(MainApplication.getMap().mapView.getCenter());
        AbstractTileSourceLayer layer = ImageryOffsetTools.getTopImageryLayer();
        String imagery = ImageryOffsetTools.getImageryID(layer);
        if (imagery == null) {
            return;
        }
        DownloadOffsetsTask download = new DownloadOffsetsTask(center, layer, imagery);
        MainApplication.worker.submit((Runnable)((Object)download));
    }

    protected void updateEnabledState() {
        AbstractTileSourceLayer layer;
        boolean state = true;
        if (!MainApplication.isDisplayingMapView() || !MainApplication.getMap().isVisible()) {
            state = false;
        }
        if (ImageryOffsetTools.getImageryID(layer = ImageryOffsetTools.getTopImageryLayer()) == null) {
            state = false;
        }
        this.setEnabled(state);
    }

    private void showOffsetDialog(List<ImageryOffsetBase> offsets) {
        if (offsets.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data for this region. Please adjust imagery layer and upload an offset.", (Object[])new Object[0]), ImageryOffsetTools.DIALOG_TITLE, 1);
            return;
        }
        OffsetDialog offsetDialog = new OffsetDialog(offsets);
        if (offsetDialog.showDialog() != null) {
            offsetDialog.applyOffset();
        }
    }

    @Override
    public void offsetStateChanged(boolean isOffsetGood) {
        this.putValue("SmallIcon", isOffsetGood ? this.iconOffsetOk : this.iconOffsetBad);
    }

    public void destroy() {
        ImageryOffsetWatcher.getInstance().unregister(this);
        super.destroy();
    }

    private class DownloadOffsetsTask
    extends SimpleOffsetQueryTask {
        private List<ImageryOffsetBase> offsets;

        DownloadOffsetsTask(LatLon center, AbstractTileSourceLayer layer, String imagery) {
            super(null, I18n.tr((String)"Loading imagery offsets...", (Object[])new Object[0]));
            try {
                String query = "get?lat=" + center.latToString(CoordinateFormat.DECIMAL_DEGREES) + "&lon=" + center.lonToString(CoordinateFormat.DECIMAL_DEGREES) + "&imagery=" + URLEncoder.encode(imagery, "UTF8");
                int radius = Main.pref.getInteger("iodb.radius", -1);
                if (radius > 0) {
                    query = query + "&radius=" + radius;
                }
                this.setQuery(query);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }

        protected void afterFinish() {
            if (!this.cancelled && this.offsets != null) {
                GetImageryOffsetAction.this.showOffsetDialog(this.offsets);
            }
        }

        @Override
        protected void processResponse(InputStream inp) throws SimpleOffsetQueryTask.UploadException {
            this.offsets = null;
            try {
                this.offsets = new IODBReader(inp).parse();
            }
            catch (IOException | SAXException e) {
                throw new SimpleOffsetQueryTask.UploadException(I18n.tr((String)"Error processing XML response: {0}", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }
}

