/*
 * Decompiled with CFR 0.152.
 */
package iodb;

import iodb.ImageryOffset;
import iodb.ImageryOffsetBase;
import iodb.ImageryOffsetTools;
import iodb.QuerySuccessListener;
import iodb.SimpleOffsetQueryTask;
import iodb.StoreImageryOffsetAction;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class DeprecateOffsetAction
extends AbstractAction {
    private ImageryOffsetBase offset;
    private QuerySuccessListener listener;

    public DeprecateOffsetAction(ImageryOffsetBase offset) {
        super(I18n.tr((String)"Deprecate Offset", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"delete"));
        this.offset = offset;
        this.setEnabled(offset != null && !offset.isDeprecated());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String desc;
        if (!MainApplication.isDisplayingMapView() || !MainApplication.getMap().isVisible()) {
            return;
        }
        String string = desc = this.offset instanceof ImageryOffset ? I18n.tr((String)"Are you sure this imagery offset is wrong?", (Object[])new Object[0]) : I18n.tr((String)"Are you sure this calibration geometry is aligned badly?", (Object[])new Object[0]);
        if (JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"Warning: deprecation is basically irreversible!", (Object[])new Object[0]) + "\n" + desc, ImageryOffsetTools.DIALOG_TITLE, 0, 2) != 0) {
            return;
        }
        DeprecateOffsetAction.deprecateOffset(this.offset, this.listener);
    }

    public void setListener(QuerySuccessListener listener) {
        this.listener = listener;
    }

    public static void deprecateOffset(ImageryOffsetBase offset) {
        DeprecateOffsetAction.deprecateOffset(offset, null);
    }

    public static void deprecateOffset(ImageryOffsetBase offset, QuerySuccessListener listener) {
        String userName = JosmUserIdentityManager.getInstance().getUserName();
        if (userName == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"To store imagery offsets you must be a registered OSM user.", (Object[])new Object[0]), ImageryOffsetTools.DIALOG_TITLE, 0);
            return;
        }
        String message = offset instanceof ImageryOffset ? I18n.tr((String)"Please enter the reason why you mark this imagery offset as deprecated", (Object[])new Object[0]) : I18n.tr((String)"Please enter the reason why you mark this calibration geometry as deprecated", (Object[])new Object[0]);
        String reason = StoreImageryOffsetAction.queryDescription(message + ":");
        if (reason == null) {
            return;
        }
        try {
            String query = "deprecate?id=" + offset.getId() + "&author=" + URLEncoder.encode(userName, "UTF8") + "&reason=" + URLEncoder.encode(reason, "UTF8");
            SimpleOffsetQueryTask depTask = new SimpleOffsetQueryTask(query, I18n.tr((String)"Notifying the server of the deprecation...", (Object[])new Object[0]));
            if (listener != null) {
                depTask.setListener(listener);
            }
            MainApplication.worker.submit((Runnable)((Object)depTask));
        }
        catch (UnsupportedEncodingException ex) {
            Logging.error((Throwable)ex);
        }
    }
}

