/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.vocabulary.RDF;

public class ListEntry
extends BaseBuiltin {
    @Override
    public String getName() {
        return "listEntry";
    }

    @Override
    public int getArgLength() {
        return 3;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        this.checkArgs(length, context);
        BindingEnvironment env = context.getEnv();
        Node list = this.getArg(0, args, context);
        Node index = this.getArg(1, args, context);
        if (!Util.isNumeric(index)) {
            return false;
        }
        Node elt = ListEntry.getEntry(list, Util.getIntValue(index), context);
        if (elt == null) {
            return false;
        }
        env.bind(args[2], elt);
        return true;
    }

    protected static Node getEntry(Node list, int i, RuleContext context) {
        int count = 0;
        Node node = list;
        while (node != null && !node.equals(RDF.Nodes.nil)) {
            if (count == i) {
                return Util.getPropValue(node, RDF.Nodes.first, context);
            }
            node = Util.getPropValue(node, RDF.Nodes.rest, context);
            ++count;
        }
        return null;
    }
}

