/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.services;

import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class MarchesPleinVentHandler
extends ToulouseDataSetHandler {
    public MarchesPleinVentHandler() {
        super(19640, "amenity=marketplace");
        this.setName("March\u00e9s de plein vent");
        this.setCategory(CAT_SERVICES);
        this.setSingleProjection(wgs84);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsOdsFilename(filename, new String[]{"MPVToulouse_OpenData"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.remove("Adresse");
            n.remove("Code Postal");
            this.replace((IPrimitive)n, "Nom", "name", new AbstractDataSetHandler.ValueReplacer(){

                public String replace(String value) {
                    return WordUtils.capitalizeFully((String)value).replace(", ", "").replace("March\u00c9", "March\u00e9");
                }
            });
            n.put("amenity", "marketplace");
            this.replace((IPrimitive)n, "Type", "note");
            String hours = "";
            for (String[] day : new String[][]{{"Lundi", "Mo"}, {"mardi", "Tu"}, {"mercredi", "We"}, {"jeudi", "Th"}, {"vendredi", "Fr"}, {"samedi", "Sa"}, {"dimanche", "Su"}}) {
                String value = n.get(day[0]);
                if (value == null) continue;
                if (!hours.isEmpty()) {
                    hours = hours + "; ";
                }
                if ((hours = hours + day[1] + " " + value.replace(" ", "").replace('\u2013', '-').replace('h', ':').replace(":-", ":00-")).endsWith(":")) {
                    hours = hours + "00";
                }
                n.remove(day[0]);
            }
            if (hours.isEmpty()) continue;
            n.put("opening_hours", hours);
        }
    }
}

