/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.cg41.datasets;

import java.net.MalformedURLException;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.cg41.Cg41Constants;

public abstract class Cg41DataSetHandler
extends FrenchDataSetHandler
implements Cg41Constants {
    public Cg41DataSetHandler(int portalId, String nationalPath) {
        this.init(portalId, nationalPath);
    }

    public Cg41DataSetHandler(int portalId, String nationalPath, String relevantTag) {
        super(relevantTag);
        this.init(portalId, nationalPath);
    }

    public Cg41DataSetHandler(int portalId, String nationalPath, boolean relevantUnion, String ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId, nationalPath);
    }

    public Cg41DataSetHandler(int portalId, String nationalPath, String ... relevantTags) {
        this(portalId, nationalPath, false, relevantTags);
    }

    public Cg41DataSetHandler(int portalId, String nationalPath, boolean relevantUnion, Tag ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId, nationalPath);
    }

    private final void init(int portalId, String nationalPath) {
        this.setNationalPortalPath(nationalPath);
        try {
            if (portalId > 0) {
                this.setLocalPortalURL("http://www.pilote41.fr/geosource/srv/fr/metadata.show?id=" + portalId);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public String getSource() {
        return "Conseil g\u00e9n\u00e9ral du Loir-et-Cher";
    }

    public String getLocalPortalIconName() {
        return "data.fr.cg41_24.png";
    }

    public String getDataLayerIconName() {
        return "data.fr.cg41_16.png";
    }
}

