/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.DataSetCategory;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.ToulouseConstants;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.ToulouseLicense;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.ToulouseModule;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.tools.I18n;

public abstract class ToulouseDataSetHandler
extends FrenchDataSetHandler
implements ToulouseConstants {
    public static final DataSetCategory CAT_ASSOCIATIONS = new DataSetCategory("Associations", "styles/standard/people.png");
    public static final DataSetCategory CAT_CITOYENNETE = new DataSetCategory("Citoyennet\u00e9", "presets/townhall.png");
    public static final DataSetCategory CAT_CULTURE = new DataSetCategory("Culture", "presets/arts_centre.png");
    public static final DataSetCategory CAT_ENFANCE = new DataSetCategory("Enfance", "presets/kindergarten.png");
    public static final DataSetCategory CAT_ENVIRONNEMENT = new DataSetCategory("Environnement", "styles/standard/service/recycling/recycling_container.svg");
    public static final DataSetCategory CAT_PATRIMOINE = new DataSetCategory("Patrimoine", "presets/ruins.png");
    public static final DataSetCategory CAT_SERVICES = new DataSetCategory("Services", "styles/standard/vehicle/services.png");
    public static final DataSetCategory CAT_SPORT = new DataSetCategory("Sport", "styles/standard/sport/soccer.png");
    public static final DataSetCategory CAT_TOPOGRAPHIE = new DataSetCategory("Topographie", "presets/peak.svg");
    public static final DataSetCategory CAT_TRANSPORT = new DataSetCategory("Transport", "presets/bus.png");
    public static final DataSetCategory CAT_URBANISME = new DataSetCategory("Urbanisme", "styles/standard/place/settlement/city.png");

    public ToulouseDataSetHandler(int portalId) {
        this.init(portalId);
    }

    public ToulouseDataSetHandler(int portalId, String relevantTag) {
        super(relevantTag);
        this.init(portalId);
    }

    public ToulouseDataSetHandler(int portalId, boolean relevantUnion, String ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId);
    }

    public ToulouseDataSetHandler(int portalId, String ... relevantTags) {
        this(portalId, false, relevantTags);
    }

    public ToulouseDataSetHandler(int portalId, boolean relevantUnion, Tag ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId);
    }

    private void init(int portalId) {
        try {
            this.setLicense((License)new ToulouseLicense());
            if (portalId > 0) {
                String url = "http://data.toulouse-metropole.fr/les-donnees/-/opendata/card/" + portalId + "--";
                this.setLocalPortalURL(url);
                this.setDataURL(url + "/resource/document");
            }
            this.addTool(new SplitByMunicipality());
            this.addTool(new SplitBySector());
            this.addTool(new SplitByNeighbourhood());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public String getSource() {
        return "ToulouseMetropole";
    }

    public String getLocalPortalIconName() {
        return "data.fr.toulouse_24.png";
    }

    public String getDataLayerIconName() {
        return "data.fr.toulouse_16.png";
    }

    protected final void setWikiPage(String wikiPage) {
        if (wikiPage != null && !wikiPage.isEmpty()) {
            this.setName(wikiPage.replace("_", " "));
            try {
                this.setWikiURL("http://wiki.openstreetmap.org/wiki/Toulouse/ToulouseMetropoleData/" + wikiPage.replace(" ", "_"));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void notifyActive() {
        ToulouseModule.downloadData();
    }

    protected class SplitByNeighbourhood
    extends SplitAction {
        public SplitByNeighbourhood() {
            super(I18n.marktr((String)"Split by neighbourhood"), I18n.tr((String)"Split this data by neighbourhood (admin_level=11).", (Object[])new Object[0]));
        }

        @Override
        protected Collection<Relation> getBoundaries() {
            return ToulouseModule.getNeighbourhoods();
        }
    }

    protected class SplitBySector
    extends SplitAction {
        public SplitBySector() {
            super(I18n.marktr((String)"Split by sector"), I18n.tr((String)"Split this data by sector (admin_level=10).", (Object[])new Object[0]));
        }

        @Override
        protected Collection<Relation> getBoundaries() {
            return ToulouseModule.getSectors();
        }
    }

    protected class SplitByMunicipality
    extends SplitAction {
        public SplitByMunicipality() {
            super(I18n.marktr((String)"Split by municipality"), I18n.tr((String)"Split this data by municipality (admin_level=8).", (Object[])new Object[0]));
        }

        @Override
        protected Collection<Relation> getBoundaries() {
            return ToulouseModule.getMunicipalities();
        }
    }

    protected abstract class SplitAction
    extends JosmAction
    implements DataSetListener {
        public SplitAction(String name, String desc) {
            super(name, null, desc, null, false);
            this.setEnabled(false);
            ToulouseModule.data.addDataSetListener((DataSetListener)this);
        }

        protected abstract Collection<Relation> getBoundaries();

        public void actionPerformed(ActionEvent e) {
            String baseName = OdPlugin.getInstance().getDialog().getDataLayer().getName();
            DataSet baseDs = MainApplication.getLayerManager().getEditDataSet();
            for (OsmPrimitive osmPrimitive : this.getBoundaries()) {
                DataSet data = new DataSet();
                for (OsmPrimitive p : NodeWayUtils.selectAllInside(Collections.singleton(osmPrimitive), (DataSet)baseDs)) {
                    if (p instanceof Node) {
                        data.addPrimitive((OsmPrimitive)new Node((Node)p));
                        continue;
                    }
                    if (p instanceof Way) {
                        data.addPrimitive((OsmPrimitive)new Way((Way)p));
                        continue;
                    }
                    if (!(p instanceof Relation)) continue;
                    data.addPrimitive((OsmPrimitive)new Relation((Relation)p));
                }
                if (data.allPrimitives().isEmpty()) continue;
                String name = osmPrimitive.get("name");
                if (name == null || name.isEmpty()) {
                    name = osmPrimitive.get("ref");
                }
                if (name == null || name.isEmpty()) {
                    name = osmPrimitive.get("description");
                }
                MainApplication.getLayerManager().addLayer((Layer)new OdDataLayer(data, baseName + "/" + name, null, (AbstractDataSetHandler)ToulouseDataSetHandler.this));
            }
        }

        public void dataChanged(DataChangedEvent event) {
            this.setEnabled(!this.getBoundaries().isEmpty());
        }

        public void primitivesAdded(PrimitivesAddedEvent event) {
        }

        public void primitivesRemoved(PrimitivesRemovedEvent event) {
        }

        public void tagsChanged(TagsChangedEvent event) {
        }

        public void nodeMoved(NodeMovedEvent event) {
        }

        public void wayNodesChanged(WayNodesChangedEvent event) {
        }

        public void relationMembersChanged(RelationMembersChangedEvent event) {
        }

        public void otherDatasetChange(AbstractDatasetChangedEvent event) {
        }
    }
}

