/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.WMSException;
import cadastre_fr.WMSLayer;
import java.io.IOException;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.tools.I18n;

public class DownloadWMSPlanImage {
    private Future<Task> task = null;
    private WMSLayer wmsLayer;
    private Bounds bounds;
    private static boolean dontGeoreference = false;
    private static String errorMessage;

    public void download(WMSLayer wmsLayer) {
        MapView mv = Main.map.mapView;
        Bounds bounds = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
        dontGeoreference = false;
        Task t = new Task(wmsLayer, bounds);
        this.wmsLayer = wmsLayer;
        this.bounds = bounds;
        this.task = Main.worker.submit((Runnable)((Object)t), t);
        if (errorMessage != null) {
            JOptionPane.showMessageDialog(Main.parent, errorMessage);
        }
    }

    public boolean waitFinished() {
        if (this.task != null) {
            try {
                this.task.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dontGeoreference;
    }

    private class Task
    extends PleaseWaitRunnable {
        Task(WMSLayer wmsLayer, Bounds bounds) {
            super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wmsLayer.getName()}));
        }

        public void realRun() throws IOException {
            this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Contacting cadastre WMS ...", (Object[])new Object[0]));
            errorMessage = null;
            try {
                if (((DownloadWMSPlanImage)DownloadWMSPlanImage.this).wmsLayer.grabber.getWmsInterface().retrieveInterface(DownloadWMSPlanImage.this.wmsLayer)) {
                    if (!DownloadWMSPlanImage.this.wmsLayer.getImages().isEmpty()) {
                        JOptionPane pane = new JOptionPane(I18n.tr((String)"Image already loaded", (Object[])new Object[0]), 1);
                        JDialog dialog = pane.createDialog(Main.parent, "");
                        CadastrePlugin.prepareDialog(dialog);
                        dialog.setVisible(true);
                        dontGeoreference = true;
                    } else if (!((DownloadWMSPlanImage)DownloadWMSPlanImage.this).wmsLayer.grabber.getWmsInterface().downloadCanceled) {
                        if (CacheControl.cacheEnabled && ((DownloadWMSPlanImage)DownloadWMSPlanImage.this).wmsLayer.grabThread.getCacheControl().loadCacheIfExist()) {
                            dontGeoreference = true;
                            DownloadWMSPlanImage.this.wmsLayer.invalidate();
                            return;
                        }
                        if (DownloadWMSPlanImage.this.wmsLayer.isRaster()) {
                            ((DownloadWMSPlanImage)DownloadWMSPlanImage.this).wmsLayer.grabber.getWmsInterface().retrieveCommuneBBox(DownloadWMSPlanImage.this.wmsLayer);
                            DownloadWMSPlanImage.this.wmsLayer.setRasterBounds(DownloadWMSPlanImage.this.bounds);
                            DownloadWMSPlanImage.this.wmsLayer.grab(DownloadWMSPlanImage.this.bounds);
                            if (((DownloadWMSPlanImage)DownloadWMSPlanImage.this).wmsLayer.grabber.getWmsInterface().downloadCanceled) {
                                DownloadWMSPlanImage.this.wmsLayer.clearImages();
                                DownloadWMSPlanImage.this.wmsLayer.invalidate();
                            } else {
                                DownloadWMSPlanImage.this.wmsLayer.joinBufferedImages();
                            }
                        } else {
                            JOptionPane pane = new JOptionPane(I18n.tr((String)"Municipality vectorized !\nUse the normal Cadastre Grab menu.", (Object[])new Object[0]), 1);
                            JDialog dialog = pane.createDialog(Main.parent, "");
                            CadastrePlugin.prepareDialog(dialog);
                            dialog.setVisible(true);
                        }
                    }
                }
            }
            catch (DuplicateLayerException e) {
                Main.warn((String)"removed a duplicated layer");
            }
            catch (WMSException e) {
                errorMessage = e.getMessage();
                ((DownloadWMSPlanImage)DownloadWMSPlanImage.this).wmsLayer.grabber.getWmsInterface().resetCookie();
            }
        }

        protected void cancel() {
            ((DownloadWMSPlanImage)DownloadWMSPlanImage.this).wmsLayer.grabber.getWmsInterface().cancel();
            dontGeoreference = true;
        }

        protected void finish() {
        }
    }
}

