/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds.io;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsLayer;
import org.openstreetmap.josm.plugins.imageryxmlbounds.data.XmlBoundsConverter;
import org.openstreetmap.josm.plugins.imageryxmlbounds.io.ValidatingImageryReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class XmlBoundsImporter
extends FileImporter
implements XmlBoundsConstants {
    public XmlBoundsImporter() {
        super(FILE_FILTER);
    }

    public DataSet parseDataSet(String source) throws IOException, SAXException {
        return this.parseDataSet(source, null);
    }

    public DataSet parseDataSet(File file) throws IOException, SAXException {
        return this.parseDataSet(null, file);
    }

    protected DataSet parseDataSet(String source, File file) throws IOException, SAXException {
        List entries;
        try (ValidatingImageryReader reader = new ValidatingImageryReader(source != null ? source : file.getAbsolutePath());){
            entries = reader.parse();
        }
        catch (SAXException e) {
            if (Main.isTraceEnabled()) {
                Main.trace((Throwable)e);
            }
            if (JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"Validating error in file {0}:\n{1}\nDo you want to continue without validating the file ?", (Object[])new Object[]{source != null ? source : file.getPath(), e.getLocalizedMessage()}), I18n.tr((String)"Open Imagery XML file", (Object[])new Object[0]), 1) != 0) {
                return null;
            }
            try (ImageryReader reader2 = new ImageryReader(source != null ? source : file.getAbsolutePath());){
                entries = reader2.parse();
            }
        }
        return XmlBoundsConverter.convertImageryEntries(entries);
    }

    protected void importData(String source, String layerName, File file, ProgressMonitor progressMonitor) throws IOException {
        try {
            DataSet dataSet = this.parseDataSet(source, file);
            XmlBoundsLayer layer = new XmlBoundsLayer(dataSet, source != null ? layerName : file.getName(), file);
            GuiHelper.runInEDT(() -> {
                if (dataSet.allPrimitives().isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data found in file {0}.", (Object[])new Object[]{source != null ? source : file.getPath()}), I18n.tr((String)"Open Imagery XML file", (Object[])new Object[0]), 1);
                }
                Main.getLayerManager().addLayer((Layer)layer);
                layer.onPostLoadFromFile();
            });
        }
        catch (SAXException e) {
            Main.error((Throwable)e);
        }
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        this.importData(null, null, file, progressMonitor);
    }

    public void importData(List<File> files, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        for (File file : files) {
            this.importData(file, progressMonitor);
        }
    }
}

