/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.base.CharMatcher;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SummaryJavadocCheck
extends AbstractJavadocCheck {
    public static final String MSG_SUMMARY_FIRST_SENTENCE = "summary.first.sentence";
    public static final String MSG_SUMMARY_JAVADOC = "summary.javaDoc";
    private static final Pattern JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN = Pattern.compile("\n[ ]+(\\*)|^[ ]+(\\*)");
    private static final String PERIOD = ".";
    private static final Set<Integer> SKIP_TOKENS = new HashSet<Integer>(Arrays.asList(6, 1, -1));
    private Pattern forbiddenSummaryFragments = CommonUtils.createPattern("^$");
    private String period = ".";

    public void setForbiddenSummaryFragments(Pattern pattern) {
        this.forbiddenSummaryFragments = pattern;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{145};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        String firstSentence = SummaryJavadocCheck.getFirstSentence(ast);
        int endOfSentence = firstSentence.lastIndexOf(this.period);
        if (endOfSentence == -1) {
            if (!SummaryJavadocCheck.isOnlyInheritDoc(ast)) {
                this.log(ast.getLineNumber(), MSG_SUMMARY_FIRST_SENTENCE, new Object[0]);
            }
        } else if (this.containsForbiddenFragment(firstSentence = firstSentence.substring(0, endOfSentence))) {
            this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
        }
    }

    private static boolean isOnlyInheritDoc(DetailNode ast) {
        boolean extraTextFound = false;
        boolean containsInheritDoc = false;
        for (DetailNode child : ast.getChildren()) {
            if (child.getType() == 10074) {
                if (!CommonUtils.isBlank(child.getText())) {
                    extraTextFound = true;
                }
            } else if (child.getType() == 10072) {
                if (child.getChildren()[1].getType() == 47) {
                    containsInheritDoc = true;
                } else {
                    extraTextFound = true;
                }
            } else if (!SKIP_TOKENS.contains(child.getType())) {
                extraTextFound = true;
            }
            if (extraTextFound) break;
        }
        return containsInheritDoc && !extraTextFound;
    }

    private static String getFirstSentence(DetailNode ast) {
        StringBuilder result = new StringBuilder();
        String periodSuffix = ". ";
        for (DetailNode child : ast.getChildren()) {
            String text = child.getText();
            if (child.getType() != 10072 && text.contains(". ")) {
                result.append(text.substring(0, text.indexOf(". ") + 1));
                break;
            }
            result.append(text);
        }
        return result.toString();
    }

    private boolean containsForbiddenFragment(String firstSentence) {
        String javadocText = JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN.matcher(firstSentence).replaceAll(" ");
        javadocText = CharMatcher.WHITESPACE.trimAndCollapseFrom(javadocText, ' ');
        return this.forbiddenSummaryFragments.matcher(javadocText).find();
    }
}

