/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;

public class ExplicitInitializationCheck
extends AbstractCheck {
    public static final String MSG_KEY = "explicit.init";
    private boolean onlyObjectReferences;

    @Override
    public final int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    public final int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public final int[] getAcceptableTokens() {
        return new int[]{10};
    }

    public void setOnlyObjectReferences(boolean onlyObjectReferences) {
        this.onlyObjectReferences = onlyObjectReferences;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!ExplicitInitializationCheck.isSkipCase(ast)) {
            DetailAST assign = ast.findFirstToken(80);
            DetailAST exprStart = assign.getFirstChild().getFirstChild();
            DetailAST type = ast.findFirstToken(13);
            if (ExplicitInitializationCheck.isObjectType(type) && exprStart.getType() == 135) {
                DetailAST ident = ast.findFirstToken(58);
                this.log(ident, MSG_KEY, ident.getText(), "null");
            }
            if (!this.onlyObjectReferences) {
                this.validateNonObjects(ast);
            }
        }
    }

    private void validateNonObjects(DetailAST ast) {
        DetailAST ident = ast.findFirstToken(58);
        DetailAST assign = ast.findFirstToken(80);
        DetailAST exprStart = assign.getFirstChild().getFirstChild();
        DetailAST type = ast.findFirstToken(13);
        int primitiveType = type.getFirstChild().getType();
        if (primitiveType == 50 && exprStart.getType() == 134) {
            this.log(ident, MSG_KEY, ident.getText(), "false");
        }
        if (ExplicitInitializationCheck.isNumericType(primitiveType) && ExplicitInitializationCheck.isZero(exprStart)) {
            this.log(ident, MSG_KEY, ident.getText(), "0");
        }
        if (primitiveType == 52 && ExplicitInitializationCheck.isZeroChar(exprStart)) {
            this.log(ident, MSG_KEY, ident.getText(), "\\0");
        }
    }

    private static boolean isZeroChar(DetailAST exprStart) {
        return ExplicitInitializationCheck.isZero(exprStart) || exprStart.getType() == 138 && "'\\0'".equals(exprStart.getText());
    }

    private static boolean isSkipCase(DetailAST ast) {
        DetailAST assign;
        boolean skipCase = true;
        if (!ScopeUtils.isLocalVariableDef(ast) && !ScopeUtils.isInInterfaceOrAnnotationBlock(ast) && (assign = ast.findFirstToken(80)) != null) {
            DetailAST modifiers = ast.findFirstToken(5);
            skipCase = modifiers.branchContains(39);
        }
        return skipCase;
    }

    private static boolean isObjectType(DetailAST type) {
        int objectType = type.getFirstChild().getType();
        return objectType == 58 || objectType == 59 || objectType == 17;
    }

    private static boolean isNumericType(int type) {
        return type == 51 || type == 53 || type == 54 || type == 55 || type == 56 || type == 57;
    }

    private static boolean isZero(DetailAST expr) {
        int type = expr.getType();
        switch (type) {
            case 137: 
            case 140: 
            case 141: 
            case 142: {
                String text = expr.getText();
                return Double.compare(CheckUtils.parseDouble(text, type), 0.0) == 0;
            }
        }
        return false;
    }
}

