/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

@Deprecated
public abstract class AbstractDeclarationCollector
extends AbstractCheck {
    private Map<DetailAST, LexicalFrame> frames;
    private LexicalFrame current;

    @Override
    public void beginTree(DetailAST rootAST) {
        LinkedList<LexicalFrame> frameStack = new LinkedList<LexicalFrame>();
        frameStack.add(new GlobalFrame());
        this.frames = new HashMap<DetailAST, LexicalFrame>();
        DetailAST curNode = rootAST;
        while (curNode != null) {
            AbstractDeclarationCollector.collectDeclarations(frameStack, curNode);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.endCollectingDeclarations(frameStack, curNode);
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.current = this.frames.get(ast);
                break;
            }
        }
    }

    private static void collectDeclarations(Deque<LexicalFrame> frameStack, DetailAST ast) {
        LexicalFrame frame = frameStack.peek();
        switch (ast.getType()) {
            case 10: {
                AbstractDeclarationCollector.collectVariableDeclarations(ast, frame);
                break;
            }
            case 21: {
                DetailAST parameterAST = ast.findFirstToken(58);
                frame.addName(parameterAST.getText());
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                DetailAST classAST = ast.findFirstToken(58);
                frame.addName(classAST.getText());
                frameStack.addFirst(new ClassFrame(frame));
                break;
            }
            case 7: {
                frameStack.addFirst(new BlockFrame(frame));
                break;
            }
            case 9: {
                if (frame instanceof ClassFrame) {
                    String name = ast.findFirstToken(58).getText();
                    DetailAST mods = ast.findFirstToken(5);
                    if (mods.branchContains(64)) {
                        ((ClassFrame)frame).addStaticMethod(name);
                    } else {
                        ((ClassFrame)frame).addInstanceMethod(name);
                    }
                }
                frameStack.addFirst(new MethodFrame(frame));
                break;
            }
            case 8: {
                frameStack.addFirst(new MethodFrame(frame));
                break;
            }
        }
    }

    private static void collectVariableDeclarations(DetailAST ast, LexicalFrame frame) {
        String name = ast.findFirstToken(58).getText();
        if (frame instanceof ClassFrame) {
            DetailAST mods = ast.findFirstToken(5);
            if (ScopeUtils.isInInterfaceBlock(ast) || mods.branchContains(64)) {
                ((ClassFrame)frame).addStaticMember(name);
            } else {
                ((ClassFrame)frame).addInstanceMember(name);
            }
        } else {
            frame.addName(name);
        }
    }

    private void endCollectingDeclarations(Queue<LexicalFrame> frameStack, DetailAST ast) {
        switch (ast.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.frames.put(ast, frameStack.poll());
                break;
            }
        }
    }

    protected final boolean isClassField(String name) {
        LexicalFrame frame = this.findFrame(name);
        return frame instanceof ClassFrame && ((ClassFrame)frame).hasInstanceMember(name);
    }

    protected final boolean isClassMethod(String name) {
        LexicalFrame frame = this.findFrame(name);
        return frame instanceof ClassFrame && ((ClassFrame)frame).hasInstanceMethod(name);
    }

    private LexicalFrame findFrame(String name) {
        LexicalFrame frame = null;
        if (this.current != null) {
            frame = this.current.getIfContains(name);
        }
        return frame;
    }

    private static class BlockFrame
    extends LexicalFrame {
        protected BlockFrame(LexicalFrame parent) {
            super(parent);
        }
    }

    private static class ClassFrame
    extends LexicalFrame {
        private final Set<String> instanceMembers = new HashSet<String>();
        private final Set<String> instanceMethods = new HashSet<String>();
        private final Set<String> staticMembers = new HashSet<String>();
        private final Set<String> staticMethods = new HashSet<String>();

        ClassFrame(LexicalFrame parent) {
            super(parent);
        }

        public void addStaticMember(String name) {
            this.staticMembers.add(name);
        }

        public void addStaticMethod(String name) {
            this.staticMethods.add(name);
        }

        public void addInstanceMember(String name) {
            this.instanceMembers.add(name);
        }

        public void addInstanceMethod(String name) {
            this.instanceMethods.add(name);
        }

        public boolean hasInstanceMember(String name) {
            return this.instanceMembers.contains(name);
        }

        public boolean hasInstanceMethod(String name) {
            return this.instanceMethods.contains(name);
        }

        @Override
        protected boolean contains(String nameToFind) {
            return super.contains(nameToFind) || this.instanceMembers.contains(nameToFind) || this.instanceMethods.contains(nameToFind) || this.staticMembers.contains(nameToFind) || this.staticMethods.contains(nameToFind);
        }
    }

    private static class MethodFrame
    extends LexicalFrame {
        protected MethodFrame(LexicalFrame parent) {
            super(parent);
        }
    }

    private static class GlobalFrame
    extends LexicalFrame {
        protected GlobalFrame() {
            super(null);
        }
    }

    private static class LexicalFrame {
        private final Set<String> varNames;
        private final LexicalFrame parent;

        protected LexicalFrame(LexicalFrame parent) {
            this.parent = parent;
            this.varNames = new HashSet<String>();
        }

        private void addName(String nameToAdd) {
            this.varNames.add(nameToAdd);
        }

        protected boolean contains(String nameToFind) {
            return this.varNames.contains(nameToFind);
        }

        private LexicalFrame getIfContains(String nameToFind) {
            LexicalFrame frame = null;
            if (this.contains(nameToFind)) {
                frame = this;
            } else if (this.parent != null) {
                frame = this.parent.getIfContains(nameToFind);
            }
            return frame;
        }
    }
}

