/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.JavadocDetailNodeParser;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.io.File;
import java.io.IOException;

public final class DetailNodeTreeStringPrinter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String JAVADOC_START = "/**";

    private DetailNodeTreeStringPrinter() {
    }

    public static String printFileAst(File file) throws IOException {
        return DetailNodeTreeStringPrinter.printTree(DetailNodeTreeStringPrinter.parseFile(file), "", "");
    }

    public static DetailNode parseJavadocAsDetailNode(DetailAST blockComment) {
        JavadocDetailNodeParser parser = new JavadocDetailNodeParser();
        JavadocDetailNodeParser.ParseStatus status = parser.parseJavadocAsDetailNode(blockComment);
        if (status.getParseErrorMessage() != null) {
            throw new IllegalArgumentException(DetailNodeTreeStringPrinter.getParseErrorMessage(status.getParseErrorMessage()));
        }
        return status.getTree();
    }

    private static DetailNode parseJavadocAsDetailNode(String javadocComment) {
        DetailAST blockComment = DetailNodeTreeStringPrinter.createFakeBlockComment(javadocComment);
        return DetailNodeTreeStringPrinter.parseJavadocAsDetailNode(blockComment);
    }

    private static String getParseErrorMessage(JavadocDetailNodeParser.ParseErrorMessage parseErrorMessage) {
        LocalizedMessage lmessage = new LocalizedMessage(parseErrorMessage.getLineNumber(), "com.puppycrawl.tools.checkstyle.checks.javadoc.messages", parseErrorMessage.getMessageKey(), parseErrorMessage.getMessageArguments(), "", DetailNodeTreeStringPrinter.class, null);
        return "[ERROR:" + parseErrorMessage.getLineNumber() + "] " + lmessage.getMessage();
    }

    public static String printTree(DetailNode ast, String rootPrefix, String prefix) {
        StringBuilder messageBuilder = new StringBuilder();
        DetailNode node = ast;
        while (node != null) {
            if (node.getType() == 10000) {
                messageBuilder.append(rootPrefix);
            } else {
                messageBuilder.append(prefix);
            }
            messageBuilder.append(DetailNodeTreeStringPrinter.getIndentation(node)).append(JavadocUtils.getTokenName(node.getType())).append(" -> ").append(JavadocUtils.escapeAllControlChars(node.getText())).append(" [").append(node.getLineNumber()).append(':').append(node.getColumnNumber()).append(']').append(LINE_SEPARATOR).append(DetailNodeTreeStringPrinter.printTree(JavadocUtils.getFirstChild(node), rootPrefix, prefix));
            node = JavadocUtils.getNextSibling(node);
        }
        return messageBuilder.toString();
    }

    private static String getIndentation(DetailNode node) {
        boolean isLastChild = JavadocUtils.getNextSibling(node) == null;
        DetailNode currentNode = node;
        StringBuilder indentation = new StringBuilder();
        while (currentNode.getParent() != null) {
            if ((currentNode = currentNode.getParent()).getParent() == null) {
                if (isLastChild) {
                    indentation.append("`--");
                    continue;
                }
                indentation.append("|--");
                continue;
            }
            if (JavadocUtils.getNextSibling(currentNode) == null) {
                indentation.insert(0, "    ");
                continue;
            }
            indentation.insert(0, "|   ");
        }
        return indentation.toString();
    }

    private static DetailNode parseFile(File file) throws IOException {
        FileText text = new FileText(file.getAbsoluteFile(), System.getProperty("file.encoding", "UTF-8"));
        return DetailNodeTreeStringPrinter.parseJavadocAsDetailNode(text.getFullText().toString());
    }

    private static DetailAST createFakeBlockComment(String content) {
        DetailAST blockCommentBegin = new DetailAST();
        blockCommentBegin.setType(145);
        blockCommentBegin.setText("/*");
        blockCommentBegin.setLineNo(0);
        blockCommentBegin.setColumnNo(-JAVADOC_START.length());
        DetailAST commentContent = new DetailAST();
        commentContent.setType(183);
        commentContent.setText("*" + content);
        commentContent.setLineNo(0);
        commentContent.setColumnNo(-1);
        DetailAST blockCommentEnd = new DetailAST();
        blockCommentEnd.setType(182);
        blockCommentEnd.setText("*/");
        blockCommentBegin.setFirstChild(commentContent);
        commentContent.setNextSibling(blockCommentEnd);
        return blockCommentBegin;
    }
}

