/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.PropertyCacheFile;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.BeforeExecutionFileFilter;
import com.puppycrawl.tools.checkstyle.api.BeforeExecutionFileFilterSet;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.RootModule;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.SeverityLevelCounter;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Checker
extends AutomaticBean
implements MessageDispatcher,
RootModule {
    public static final String EXCEPTION_MSG = "general.exception";
    private static final Log LOG = LogFactory.getLog(Checker.class);
    private final SeverityLevelCounter counter = new SeverityLevelCounter(SeverityLevel.ERROR);
    private final List<AuditListener> listeners = new ArrayList<AuditListener>();
    private final List<FileSetCheck> fileSetChecks = new ArrayList<FileSetCheck>();
    private final BeforeExecutionFileFilterSet beforeExecutionFileFilters = new BeforeExecutionFileFilterSet();
    private final FilterSet filters = new FilterSet();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private String basedir;
    private String localeCountry = Locale.getDefault().getCountry();
    private String localeLanguage = Locale.getDefault().getLanguage();
    private ModuleFactory moduleFactory;
    private ClassLoader moduleClassLoader;
    private Context childContext;
    private String[] fileExtensions = CommonUtils.EMPTY_STRING_ARRAY;
    private SeverityLevel severityLevel = SeverityLevel.ERROR;
    private String charset = System.getProperty("file.encoding", "UTF-8");
    private PropertyCacheFile cache;
    private boolean haltOnException = true;

    public Checker() {
        this.addListener(this.counter);
    }

    public void setCacheFile(String fileName) throws IOException {
        Configuration configuration = this.getConfiguration();
        this.cache = new PropertyCacheFile(configuration, fileName);
        this.cache.load();
    }

    public void removeBeforeExecutionFileFilter(BeforeExecutionFileFilter filter) {
        this.beforeExecutionFileFilters.removeBeforeExecutionFileFilter(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.removeFilter(filter);
    }

    @Override
    public void destroy() {
        this.listeners.clear();
        this.beforeExecutionFileFilters.clear();
        this.filters.clear();
        if (this.cache != null) {
            try {
                this.cache.persist();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to persist cache file.", ex);
            }
        }
    }

    public void removeListener(AuditListener listener) {
        this.listeners.remove(listener);
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    @Override
    public int process(List<File> files) throws CheckstyleException {
        if (this.cache != null) {
            this.cache.putExternalResources(this.getExternalResourceLocations());
        }
        this.fireAuditStarted();
        for (FileSetCheck fsc : this.fileSetChecks) {
            fsc.beginProcessing(this.charset);
        }
        this.processFiles(files);
        this.fileSetChecks.forEach(FileSetCheck::finishProcessing);
        this.fileSetChecks.forEach(FileSetCheck::destroy);
        int errorCount = this.counter.getCount();
        this.fireAuditFinished();
        return errorCount;
    }

    private Set<String> getExternalResourceLocations() {
        HashSet<String> externalResources = new HashSet<String>();
        this.fileSetChecks.stream().filter(check -> check instanceof ExternalResourceHolder).forEach(check -> {
            Set<String> locations = ((ExternalResourceHolder)((Object)check)).getExternalResourceLocations();
            externalResources.addAll(locations);
        });
        this.filters.getFilters().stream().filter(filter -> filter instanceof ExternalResourceHolder).forEach(filter -> {
            Set<String> locations = ((ExternalResourceHolder)((Object)filter)).getExternalResourceLocations();
            externalResources.addAll(locations);
        });
        return externalResources;
    }

    private void fireAuditStarted() {
        AuditEvent event = new AuditEvent(this);
        for (AuditListener listener : this.listeners) {
            listener.auditStarted(event);
        }
    }

    private void fireAuditFinished() {
        AuditEvent event = new AuditEvent(this);
        for (AuditListener listener : this.listeners) {
            listener.auditFinished(event);
        }
    }

    private void processFiles(List<File> files) throws CheckstyleException {
        for (File file : files) {
            try {
                String fileName = file.getAbsolutePath();
                long timestamp = file.lastModified();
                if (this.cache != null && this.cache.isInCache(fileName, timestamp) || !CommonUtils.matchesFileExtension(file, this.fileExtensions) || !this.acceptFileStarted(fileName)) continue;
                if (this.cache != null) {
                    this.cache.put(fileName, timestamp);
                }
                this.fireFileStarted(fileName);
                SortedSet<LocalizedMessage> fileMessages = this.processFile(file);
                this.fireErrors(fileName, fileMessages);
                this.fireFileFinished(fileName);
            }
            catch (Exception ex) {
                throw new CheckstyleException("Exception was thrown while processing " + file.getPath(), ex);
            }
            catch (Error error) {
                throw new Error("Error was thrown while processing " + file.getPath(), error);
            }
        }
    }

    private SortedSet<LocalizedMessage> processFile(File file) throws CheckstyleException {
        TreeSet<LocalizedMessage> fileMessages = new TreeSet<LocalizedMessage>();
        try {
            FileText theText = new FileText(file.getAbsoluteFile(), this.charset);
            for (FileSetCheck fsc : this.fileSetChecks) {
                fileMessages.addAll(fsc.process(file, theText));
            }
        }
        catch (IOException ioe) {
            LOG.debug("IOException occurred.", ioe);
            fileMessages.add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", EXCEPTION_MSG, new String[]{ioe.getMessage()}, null, this.getClass(), null));
        }
        catch (Exception ex) {
            if (this.haltOnException) {
                throw ex;
            }
            LOG.debug("Exception occurred.", ex);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            fileMessages.add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", EXCEPTION_MSG, new String[]{sw.getBuffer().toString()}, null, this.getClass(), null));
        }
        return fileMessages;
    }

    private boolean acceptFileStarted(String fileName) {
        String stripped = CommonUtils.relativizeAndNormalizePath(this.basedir, fileName);
        return this.beforeExecutionFileFilters.accept(stripped);
    }

    @Override
    public void fireFileStarted(String fileName) {
        String stripped = CommonUtils.relativizeAndNormalizePath(this.basedir, fileName);
        AuditEvent event = new AuditEvent(this, stripped);
        for (AuditListener listener : this.listeners) {
            listener.fileStarted(event);
        }
    }

    @Override
    public void fireErrors(String fileName, SortedSet<LocalizedMessage> errors) {
        String stripped = CommonUtils.relativizeAndNormalizePath(this.basedir, fileName);
        boolean hasNonFilteredViolations = false;
        for (LocalizedMessage element : errors) {
            AuditEvent event = new AuditEvent(this, stripped, element);
            if (!this.filters.accept(event)) continue;
            hasNonFilteredViolations = true;
            for (AuditListener listener : this.listeners) {
                listener.addError(event);
            }
        }
        if (hasNonFilteredViolations && this.cache != null) {
            this.cache.remove(fileName);
        }
    }

    @Override
    public void fireFileFinished(String fileName) {
        String stripped = CommonUtils.relativizeAndNormalizePath(this.basedir, fileName);
        AuditEvent event = new AuditEvent(this, stripped);
        for (AuditListener listener : this.listeners) {
            listener.fileFinished(event);
        }
    }

    @Override
    public void finishLocalSetup() throws CheckstyleException {
        Locale locale = new Locale(this.localeLanguage, this.localeCountry);
        LocalizedMessage.setLocale(locale);
        if (this.moduleFactory == null) {
            if (this.moduleClassLoader == null) {
                throw new CheckstyleException("if no custom moduleFactory is set, moduleClassLoader must be specified");
            }
            Set<String> packageNames = PackageNamesLoader.getPackageNames(this.moduleClassLoader);
            this.moduleFactory = new PackageObjectFactory(packageNames, this.moduleClassLoader);
        }
        DefaultContext context = new DefaultContext();
        context.add("charset", this.charset);
        context.add("classLoader", this.classLoader);
        context.add("moduleFactory", this.moduleFactory);
        context.add("severity", this.severityLevel.getName());
        context.add("basedir", this.basedir);
        this.childContext = context;
    }

    @Override
    protected void setupChild(Configuration childConf) throws CheckstyleException {
        Object filter;
        Object child;
        String name = childConf.getName();
        try {
            child = this.moduleFactory.createModule(name);
            if (child instanceof AutomaticBean) {
                AutomaticBean bean = (AutomaticBean)child;
                bean.contextualize(this.childContext);
                bean.configure(childConf);
            }
        }
        catch (CheckstyleException ex) {
            throw new CheckstyleException("cannot initialize module " + name + " - " + ex.getMessage(), ex);
        }
        if (child instanceof FileSetCheck) {
            FileSetCheck fsc = (FileSetCheck)child;
            fsc.init();
            this.addFileSetCheck(fsc);
        } else if (child instanceof BeforeExecutionFileFilter) {
            filter = (BeforeExecutionFileFilter)child;
            this.addBeforeExecutionFileFilter((BeforeExecutionFileFilter)filter);
        } else if (child instanceof Filter) {
            filter = (Filter)child;
            this.addFilter((Filter)filter);
        } else if (child instanceof AuditListener) {
            AuditListener listener = (AuditListener)child;
            this.addListener(listener);
        } else {
            throw new CheckstyleException(name + " is not allowed as a child in Checker");
        }
    }

    public void addFileSetCheck(FileSetCheck fileSetCheck) {
        fileSetCheck.setMessageDispatcher(this);
        this.fileSetChecks.add(fileSetCheck);
    }

    public void addBeforeExecutionFileFilter(BeforeExecutionFileFilter filter) {
        this.beforeExecutionFileFilters.addBeforeExecutionFileFilter(filter);
    }

    public void addFilter(Filter filter) {
        this.filters.addFilter(filter);
    }

    @Override
    public final void addListener(AuditListener listener) {
        this.listeners.add(listener);
    }

    public final void setFileExtensions(String ... extensions) {
        if (extensions == null) {
            this.fileExtensions = null;
        } else {
            this.fileExtensions = new String[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                String extension = extensions[i];
                this.fileExtensions[i] = CommonUtils.startsWithChar(extension, '.') ? extension : "." + extension;
            }
        }
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    public void setLocaleCountry(String localeCountry) {
        this.localeCountry = localeCountry;
    }

    public void setLocaleLanguage(String localeLanguage) {
        this.localeLanguage = localeLanguage;
    }

    public final void setSeverity(String severity) {
        this.severityLevel = SeverityLevel.getInstance(severity);
    }

    public final void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Deprecated
    public final void setClassloader(ClassLoader loader) {
        this.classLoader = loader;
    }

    @Override
    public final void setModuleClassLoader(ClassLoader moduleClassLoader) {
        this.moduleClassLoader = moduleClassLoader;
    }

    public void setCharset(String charset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(charset)) {
            String message = "unsupported charset: '" + charset + "'";
            throw new UnsupportedEncodingException(message);
        }
        this.charset = charset;
    }

    public void setHaltOnException(boolean haltOnException) {
        this.haltOnException = haltOnException;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.reset();
        }
    }
}

